Grant among the first to address the mental health needs of Pacific Islanders
Credit: UC Riverside.
RIVERSIDE, Calif. – Pacific Islanders are persons who trace their roots to the native peoples of Hawaii, Guam, Samoa, or other Pacific Islands. Although they make up the third fastest growing racial group in the U.S., their mental health needs and attitudes regarding mental illness are poorly understood. One reason for this is that discussing mental health problems with others is largely taboo in their cultures. Also, stigma, language barriers, and lack of information about available resources and services complicate Pacific Islanders' access to mental health services.
To address this clinical gap, Andrew Subica, Ph.D., an assistant professor of social medicine and population health in the School of Medicine at the University of California, Riverside, has received a grant from the National Institute of Mental Health to conduct one of the first studies of mental health and mental illness among Pacific Islanders.
The two-year $452,000 grant is titled, "Engaging Pacific Islander Perspectives on Mental Illness and Mental Health Service Engagement."
"The goal of the study is to capture the perspectives of community-dwelling Pacific Islanders in two large Pacific Islander communities–Samoans in Los Angeles and the Marshallese in Arkansas–in order to develop the first culturally attuned manualized intervention to promote Pacific Islander engagement in mental health services," said Subica, the grant's principal investigator and a member of UCR's Center for Healthy Communities.
Pacific Islanders have been found to experience severe health disparities, yet have received very little research attention focused on exploring and addressing their unique challenges. Subica said, "Pacific Islanders constitute an invisible, understudied racial group suffering large mental and physical health disparities. Unfortunately, we know less about their mental health needs or how to treat them than perhaps any other U.S. racial group." He further explained that, like indigenous American Indians, many Pacific Islander groups are vulnerable to these health disparities because of their exposure to extensive historical trauma including U.S. colonization.
"For example, in 1893, the U.S. overthrew the Hawaiian Monarchy, an aggressive act that has placed present day Native Hawaiians at perpetual social, economic, and health disadvantage in their own native homelands," he said. "Later, the U.S. military tested thousands of nuclear bombs in the Marshall Islands for over a decade, contaminating many Marshallese people, food sources, and lands with radioactive fallout. As a result of these experiences and their own unique cultural perspectives, Pacific Islanders feel reluctant to trust and seek U.S. mental health services."
Pacific Islanders are heavily concentrated in the western United States. According to the World Health Organization, Pacific Island nations suffer a growing rate of alcohol and drug problems. Where available, mental health services are "often extremely limited, poorly distributed and staffed, and under-funded." And more than half the Pacific Island nations have no dedicated mental health budget.
Subica, recently named a National Institute of Minority Health and Health Disparities Health Disparities Research Institute Scholar, will be joined in the research by Greer Sullivan and Bruce Link at UCR; Nia Aitaoto at the University of Arkansas Medical Sciences; and Ann Marie Yamada and Benjamin Henwood at the USC School of Social Work.
The grant begins in May 2017 and ends in April 2019. During the first year, the researchers will conduct surveys and focus groups with Samoan and Marshallese community members to gain a better understanding of their mental health needs, cultural protective factors, and barriers to services. In the second year, the researchers will gather groups of community members to shape existing service engagement strategies to fit their unique cultural perspectives, strengths, and needs. Through this grant, the researchers hope to gain information that will help mental health service systems better engage Pacific Islanders in treatment services.
###