Unusually loud report from the City’s Ethics Commission condemns ethical vagueness and inadequate reporting measures regarding millions of dollars in tickets and other perks offered to city services and distributed to employees, politicians and their guests .
The report, which was quietly released on September 29, describes the problematic nature of the $ 1.2 million in tickets disseminated by city departments since 2009. In some cases, third-party vendors are in fact contractually binding. mandated providing the city with plenty of free tickets – a longstanding tradition in San Francisco, the Ethics Report bluntly described as “a culture of expectation that is the basis of a pay-to-play system.”
Similarly, the War Memorial Board of Trustees – which oversees the auditorium building and is populated by some of the city’s wealthiest elites – has received more than $ 516,000 in free performance tickets since 2012.
“Like Rec and Park, War Memorial has built the flow of free tickets into their rental agreements with tenants,” the report read. Its current pact with the San Francisco Opera Association “requires the Opera to provide 10 tickets for each performance to the department for the use of War Memorial administrators.” The agreement further specifies the exact seats that must be provided for the use of directors.
At the heart of this ethics report is an examination of ways to circumvent the city’s “narrow source rule”. This policy prevents city officials or employees from directly accepting gifts from an individual or group who has a contract with their department or who has recently sought to influence them. But this rule can be circumvented by presenting tickets or money for a party to a department, which is then broadcast to its recipients – and inducing much the same result.
Understandably, former Public Works boss and accused federal criminal Mohammed Nuru looked to this report as Banquo’s ghost. His arrest in January 2020 sparked a number of inward-looking city acts, including this most recent report.
Neither he nor his Public Works employees could legally have taken gifts and largesse from Recology. But, as municipal and federal legal affairs were revived, this rule was evaded by Recology by funneling money through the department and into nonprofits that Nuru used to fund lavish parties for employees, politicians and their guests.
Similarly, War Memorial administrators could not accept gifts – in this case valued at thousands of dollars – from the San Francisco Opera Association. But they can accept free tickets (contractually mandated), distributed by a third party. But the central problem remains: the report notes that the same trustee who initiated the 2015 rental agreement with the Opera received $ 5,360 in opera tickets in the following calendar year.
“This example illustrates the factors that can give rise to an appearance of undue influence and payment to play when restricted sources provide free event tickets to City officials through a City service.” , notes the report. “These concerns are what the narrow source rule was created to prevent.”
The supervisory board also oversees the rental rates for the war memorial. And former supervisor Norman Yee received $ 1,000 in free tickets, while current supervisor Catherine Stefani received four tickets valued at $ 762.
It’s clear, however, that the king of ticketing is the Parks and Recreation department, much of which comes from the Outside Lands festival. The ministry said it distributed 1,855 Outside Lands tickets between 2015 and 2019 alone – valued at $ 431,000.
It’s problematic: the promoter of Outside Lands, Another Planet Entertainment, would be considered a small donor. But another planet is in fact obligatory to provide these tickets as part of its agreement with Rec and Park. “If anything,” the report sums up, “requiring free tickets that are provided for the personal use of City officials in a City contract only reinforces the tickets and the benefits they offer are a cost to do business for City entrepreneurs. “
Of the 1,855 off-land tickets requested and received by Rec and Park, 1,442 (78%) were reported as intended for City officials, and 1,202 (65%) were reported for Rec and Park officials. .
Another Planet, incidentally, has a contract with the city’s real estate division for the exclusive use of the Bill Graham municipal auditorium. The report curtly notes that Real Estate has not put language in its contracts to extract free tickets to shows.
In addition to tickets, the report highlights the problematic use of outside funds for city parties. These include:
* A June 2019 planning department party funded in part by real estate developers Tishman Speyer, One Vassar and Associate Capital and law firms Rueben, Junius, & Rose, J. Abrams Law PC and Gibson, Dunn, & Crutcher LLP. Ground Floor Public Affairs and the Residential Builders Association also participated. Lobbyists Rueben, Junius and Rose said they lobbied seven high-level planning staff on the day of the party – and it was not determined whether that lobbying took place at the party. himself.
* Four parties at San Francisco International Airport marking the opening of the new Harvey Milk International Terminal were funded with more than $ 1 million in private donations. “Most of this funding came from entities that would likely be restricted sources for airport officials,” the report notes. These included Hensel Phelps Construction, which donated $ 99,000 and has a $ 1.1 billion construction contract with SFO.
* In December 2019, the Entertainment Commission hosted a party where 86% of the event’s subscription funds were provided by entities with licenses granted by the Entertainment Commission.
* The mayor’s office in 2019 hosted a holiday party in which the source of $ 3,800 in funds could not be explained. The ethics report directly compares the behavior of the mayor’s office to Nuru: “This arrangement is similar to DPW parties in that a non-municipal organization funded a free vacation party for city officials using money collected from undisclosed private sources. In the case of DPW, the Justice Department found that the use of nonprofit intermediaries was a deliberate attempt to cover up the true source of the funds (which was Recology) and accused several people of money laundering. In the case of the Mayor’s Day and the nonprofit organization that paid for it, neither the Mayor’s office website nor the nonprofit revealed to the public who was the source of the funding or why the source has not been identified.
The Ethics Commission suggests, among many other remedies, that the rules be tightened and that the balkanized method of managing and tracking gifts be centralized.