Kinetic Energy Recovery Systems in Formula One, by Franca Davenport
It used to be easy to be cool in Formula One. Fast cars, danger and, in the good old days, hard partying. It was a simple ethic, with which sponsors were happy to be associated. However, with the rise of eco-chic, F1 must do more to keep its image desirable. It has to be seen to be green, and not just British racing green.
In the 2009 regulations, governing body the FIA declared a freeze on engine development. It also mandated energy recovery systems from regenerative braking, and the acronym KERS (Kinetic Energy Recovery System) was coined. Labelled by some as the CURSE, this new rule has received a mixed reaction. Although no-one is against it "in principle", Toyota has been quoted as calling it "primitive", while Ferrari said it left their engineers "twiddling their thumbs". Concerns have been raised about time, cost and safety (especially from escaping flywheels). There is also the irony that the systems will actually make no net carbon savings because the teams will simply use the stored energy to make the cars faster, but as long as Max Mosley is still at the helm of the FIA, it's almost certain these measures will go through.
Broadly speaking there are two main types of solution: electrical and mechanical. A company called Flybrid Systems has developed a purely mechanical flywheel KERS. ‘"We're talking to several teams," says managing partner Jon Hilton, ex-Renault F1, "But nothing's definite in this business and everyone will leave it to the last moment." As the name suggests, Flybrid's system uses a 64,000rpm flywheel as the energy storage device. Its high speed allows it to be small and light (about 11lb, although the system weight with casing is nearer 24lbs) and it is run in a vacuum to avoid friction. Linking the flywheel to the wheels is a Torotrak toroidal CVT (continuously variable transmission). Unlike an electrical KERS, this means there is no change of energy state and Hilton estimates it's 70 per cent efficient. "If there is a disadvantage," he says. "It's locating the device and the effect on the centre of gravity. Since it is one solid lump there isn't the option of distributing it around the car like an electrical system."
One of the keenest recipients of the KERS concept is Honda, which has also been the first to report testing it on a car. "The first test had its usual bugs but the second was very positive," says CEO Nick Fry, "But I don't want to underestimate the challenge and we're still looking at several possibilities." As might be expected, Honda is developing a mainly electrical system insofar as the energy will be recovered using a motor/generator, although it may use a flywheel for storage instead of batteries or capacitors, so it would be a sort of hybrid of a hybrid. After the Hungarian GP, Honda intends to slow the development on the 2008 car to focus on 2009. "For us it's a much more sensible strategy," says Fry.
A team who have been quietly positive about KERS is Williams F1, despite the financial pressure it places on this wholly private team. "We generally find that when the rules change it's better to get on with it," says Patrick Head, Director of Engineering, "and sponsors are very keen about this new direction." Williams is now a minority shareholder in a company specialising in flywheel hybrid technology, which has been moved to Williams HQ. "We're still looking at batteries and ultra-capacitors," says Head, "But the flywheel is our main line for energy storage."
With the diversity of possible systems, there seems to be little certainty about the suggested positive effect on overtaking. The maximum power that KERS can deliver is 80bhp which can be released either in one go or at points around the circuit. This implies an intricate control system, especially since at maximum storage capacity the system will no longer provide any regenerative braking effect. As Hilton says, "Drivers could make mistakes by simply forgetting to dispense the stored energy," which could make for interesting racing, although not quite in the way originally conceived.
In terms of fuel consumption, no-one is foreseeing that the 2009 KERS will have a huge effect since it will be used additionally rather than as an alternative to the engine. However, this isn't really the issue since the actual racing and testing of the cars make up roughly one per cent of a team's carbon footprint.
Nevertheless it seems that F1 will see some big changes in the near future. Energy recovery from the cooling system has been suggested from 2011 and from the exhaust when new engines – probably small-capacity turbos – are introduced in 2013. Silverstone has seen its fair share of F1 cars in the last 60 years but, by the time its sixty-four, it could be seeing something completely different - if it's still on the F1 calendar by then...