Many people with thyroid conditions wonder what they should eat, and whether or not there are foods which can help improve their thyroid health. While there are certain foods those with a thyroid condition should consume, in this article I’m going to discuss certain thyroid-inhibiting foods you should try to avoid.
These thyroid-inhibiting foods are also known as goitrogens, and I’m going to discuss the negative impact they can have on your health, and list some of the common foods which you will want to minimize your consumption of, and in some cases, completely avoid. This is especially true if you have a hypothyroid condition, but even if you have hyperthyroidism you still want to minimize the consumption of these foods.
Here are some examples of goitrogens:
• Broccoli
• Cauliflower
• Kale
• Brussels Sprouts
• Mustard Greens
• Radishes
• Spinach
• Strawberries
• Peaches
• Soy-Based Foods
• Peanuts
You’ll notice that some of these goitrogenic foods are considered to be healthy foods, such as broccoli, cauliflower, brussels sprouts, etc. Because of this, it’s probably important to mention that those people who don’t have a thyroid condition shouldn’t have a problem eating these vegetables.
In other words, eating cruciferous vegetables will most likely not lead to the development of a thyroid condition. On the other hand, for someone who has a thyroid condition, especially hypothyroidism, consuming goitrogens can actually worsen your condition.
So does this mean that someone with a hypothyroid condition should completely avoid these goitrogenic foods? Well, for those who choose to manage their symptoms by taking synthetic or natural thyroid hormone, then eating these foods in moderation probably isn’t a big deal. So for example, having some broccoli or strawberries every now and then, or even a soy-based product isn’t too big of a deal. But it probably isn’t a good idea to eat these regularly, even if you are managing your symptoms by taking thyroid hormone.
On the other hand, when a patient of mine first begins a natural treatment protocol, I do recommend that they avoid these goitrogenic foods, at least for awhile. Assuming it is possible to cure their condition, then after restoring their thyroid health back to normal they can begin eating some of these foods in moderation again.
How Do Goitrogens Inhibit Thyroid Activity?
The way that goitrogens work is that they inhibit iodine metabolism. With regards to thyroid health, iodine is important in the formation of thyroid hormone. As a result, if iodine cannot be properly utilized by the thyroid gland, then the formation of thyroid hormone won’t take place. As you can imagine, this is not a good thing for someone with hypothyroidism, as they already have problems with the manufacturing of thyroid hormone even without consuming goitrogens.
Some Goitrogenic Foods Are Worse Than Others
While I definitely recommend that anyone with a thyroid condition minimize their.
On the other hand, I’m not a big fan of soy, as while the soy industry has done a great job of marketing soy as being healthy for us, a lot of research has proved otherwise. I mentioned above where someone who doesn’t have a thyroid disorder is unlikely to develop one by consuming goitrogens. Well, soy might be an exception to this, as eating soy frequently can potentially lead to numerous health problems.
Once again, for someone who is not following a natural treatment protocol and is relying on the prescription drugs to manage their symptoms, eating some soy-based foods every now and then is fine. On the other hand, since a person who has a hypothyroid condition should try to minimize the amount of goitrogens they eat, when they do choose to eat such foods it would be a better choice to eat the cruciferous vegetables, since they do offer greater health benefits.
Also, some goitrogenic foods are considered “mildly goitrogenic”. Some examples include spinach, strawberries, and peaches. So while anyone with a hypothyroid condition will want to minimize their consumption of these foods, eating them aren’t as bad for your thyroid gland as other goitrogenic foods that aren’t classified as being “mildly goitrogenic”, such as broccoli, cauliflower, and soy.
By the way, some sources do show that cooking these foods may destroy the goitrogenic activity. I’m not sure if this has been fully confirmed through research studies, and so while it might be okay for someone with hypothyroidism to eat cooked cruciferous vegetables and other goitrogenic foods regularly, I still would be cautious about consuming too much.
Should People With Hyperthyroidism Use Goitrogenic Foods As A Treatment Method?
Some sources suggest that people with hyperthyroidism should eat a good amount of goitrogenic foods. The rationale behind this is that since hyperthyroidism involves an excess of iodine production, and because goitrogens inhibit the production of thyroid hormone, then it would make sense to “load up” on these thyroid inhibiting foods. I personally disagree with this, as while someone with a hyperthyroid condition will be able to eat more goitrogens when compared with someone with hypothyroidism, this doesn’t mean they should intentionally eat a lot of goitrogenic foods.
The reason for this is because simply taking goitrogenic foods isn’t going to cure the hyperthyroid condition. While eating goitrogenic foods might do a decent job of managing the symptoms if they are consumed in sufficient quantities, my ultimate goal is to try to restore the health of the person’s thyroid gland back to it’s normal state, which in many cases can be accomplished through a natural thyroid treatment protocol. So while I won’t tell a patient of mine with hyperthyroidism to reduce his or her consumption of goitrogenic foods (at least not the healthier choices such as broccoli, cauliflower, etc.), I definitely won’t recommend that they eat more of them, as this simply isn’t necessary.
In summary, anyone with hypothyroidism definitely needs to be careful when it comes to the consumption of goitrogenic foods. And if you do decide to follow a natural thyroid treatment protocol, then it probably will be necessary for you to completely avoid these foods for a certain period of time. Also, someone with a hyperthyroid disorder should not intentionally consume an abundance of goitrogenic foods in order to inhibit thyroid activity, as for most people with hyperthyroidism, a natural thyroid treatment protocol can restore their health back to normal without having to consume large quantities of goitrogens.
Other Articles You Might Like To Read:
My Personal Thyroid Diet
A Modified Thyroid Diet
5 Essential Supplements For Optimal Thyroid Health
What Is The Best Thyroid Supplement To Take?
What Roles Do Food Allergies Play In Thyroid Health?