Living with art
Trust is design’s great intangible. Once it is implicit, the project has the best possible chance of ending up beyond the client’s wildest dreams. It also ensures that the process is a joy every step of the way. With this Brazil-based couple, trust existed before the start, thanks to a shared connection with a one-time GRADE colleague. The confidence it engendered became the catalyst for every decision in the couple’s art-filled pied-à-terre in Sir Norman Foster’s tower in far-west Chelsea, practically on the Hudson River. For art lovers as passionate as these two, no other building and no other neighbourhood made sense.
With interior and exterior architecture as distinctive as Foster’s, it is natural to take advantage of the design cues and opportunities they provide. The sweep of the living room soffit profile, for instance, sparks many of the custom design details. The same is true for the pale, golden champagne tint of the structural framework. As for the panoramic views of the skyline, river and harbour, what could be more inspiring?
A coffee table of kiln-fused glass and cast bronze, designed by Stacklab, slips neatly into the living room. Along the window perimeter are a pair of Hervé Langlais club chairs and an Ox chair by Hans Wegner. Image: Richard Powers
The entry gallery, the through-line between the public and private areas, showcases just some of the art and iconic contemporary furnishings assembled over the course of an especially exciting design process. A stepped crown moulding incorporates the curve of the soffit, introducing a touch of tradition filtered through a modern perspective.
With ceilings leafed in white gold and walls panelled in ash bleached and stained to emphasise the open grain, the gallery is warm, luxurious and just texturally interesting enough to heighten the experience of the group of works it displays. They include pieces by Annie Morris, Josef Albers, Ingrid Donat, Perrin & Perrin, Dan Flavin and others we curated, including its centrepiece, Lucio Fontana’s Concetto Spaziale, a most brilliant finishing touch.
The living room encompasses two seating areas oriented to capture panoramic views that sweep east and south. Each grouping mixes pieces by some of the 20th century’s best-known makers with custom designs that enhance the art-above-all point of view. A captivating painting by Ellen Gallagher, the very first work selected for this project, informs the room’s elements from form to colour palette.
Stationary wall wings separate the living and dining rooms without a more formal closure; these incorporate the soffit profile, as do the details of the cowhide-lined built-in units. Over the dining table, a petal-like arrangement of suede-wrapped panels and delicate descending lights flowers on the ceiling. The library houses an ever-expanding collection of catalogues and art books, as well as comfortable seating and lighting for serious readers. The shelves float on a wall of fabric-wrapped panels set to reveal shadow lines created by a subtle undulation.
A backdrop for Dimorestudio’s sconces, the custom headboard reinterprets the curve of the soffit in yet another way. Overhead, Ingo Maurer’s Lil Luxury ceiling light introduces a touch of gold, repeated by Franck Evennou’s set of three nesting tables. Image: Richard Powers
In the master bedroom, black and gold accents highlight a tonal palette of creams, off-whites, light greys. A fantastic tangle of a lamp by Jean Royère spreads its vines across the hallway; its bold black lines prefigure those in the bedroom’s Matisse aquatint. Its curves, as well as Foster’s, influence the custom bedroom furnishings. The twin beds in the guest room pick up on the same detail.
It is rare and wonderful to share such trust with clients. When it happens, there’s no predicting what art can come of it. And not just the works of art themselves, but the art of furniture, of curating, of placement, and above all, the art of living.
See an interview with Edward Yedid and Thomas Hickey, founders of Grade New York, here.
This feature is an excerpt from New York Contemporary: Grade Architecture and Interiors by Thomas Hickey and Edward Yedid. Published here courtesy of Monacelli Press, it has been edited to accommodate house style.