Two Lane instructors have rallied together to present a free, four-part documentary movie series for students and faculty, which depicts injustices toward women today on a global scale.
The weekly screenings are shown in Building 19, Room 250.
Lane health and sustainability instructor Susie Cousar and Women’s Center coordinator Patsy Raney, a part-time social science instructor, said they are bringing the issues discussed in their classes to a larger audience.
“It’s a class about patriarchy. It’s a class about dominance over ways of being in the world,” Cousar said about her Global Health and Sustainability course. “Dominance over ways of being lead to hierarchical thinking, which leads to ‘some people are worth something and some people aren’t ’ — which leads to pretty much any other health issue we have in the world.”
The film series consisting of three different films: Half the Sky, America the Beautiful and Miss Representation.
Half the Sky is a four-hour documentary split into two, two-hour showings. The first was shown Feb. 12.
“The first two (films) are a global perspective, while the last two focus more on in this country — contemporary issues here. I want people to see those connections too,” Raney said. “Because a lot of my students will say, when they read about the realities of some sort of culture practices … they’ll say, ‘Those poor women. I’m so glad I live here.’ That’s their initial response. They can’t see the connection.”
Half the Sky is adapted from a book by Nicholas D. Kristof and Sheryl WuDunn, two journalists who travel around the world documenting the struggles and oppression of women. The film addresses abuse, rape culture and injustice, which may disturb some viewers. However, the films don’t strictly focus on problems, but on empowerment, and solutions.
“People are constantly challenging these situations, organizing to change them — regular people doing extraordinary things,” Raney said.
America the Beautiful and Miss Representation deal with issues that concern women in America, such as standards of beauty, body image and the scarcity of women in power in this country.
The film series syncs with the organization One Billion Rising’s Feb. 14 Valentine’s Day celebration. One Billion Rising is a nonprofit organization that aims to fight violence and injustice towards women.
Lane student Vicki Epperson, who volunteers at Learning Service through Raney’s Women in Work course, assisted in creating the film series. Learning Service volunteers spend a minimum of 10 hours in a community organization or on a special project in relation to a relevant class to earn alternative points to a final course project.
“There are a few more responsibilities than I imagined for a 10-hour project. However, I’m enjoying every minute,” Epperson wrote in an email. “I am coordinating viewing rooms, dates/times, advertising, goodies (free popcorn) and presenting information about the movie series in each of my classes. I will also facilitate at each of the movies.”
Epperson took on this project because she was passionate about the themes and significance of the films.
“We need to be educated that the insidious nature of gender discrimination is still very real,” she wrote.
Rage, agitation and discomfort are a few of the adjectives Raney used to describe the personal impressions of these movies.
“There are going to be issues there and things that are brought to people’s attention that are hard to look at, literally and figuratively, but also very important to see,” Raney said. “The awareness has to be there before action can be taken.”
Both instructors encourage students to attend these screenings, but to be prepared for the global reality of these films.
“You have to be open to the fact that things around you are happening that you are not aware of, and that part of getting the most out of this series is to come in open to things that you think you would know about that you don’t know about,” Cousar said, “and it can be very painful. Part of the process, though — it’s the pain that brings you to a place of empowerment like you have never felt.”
Admission for these events is free and organic popcorn will be provided for participants. Sign in for the event is required at the beginning of each viewing.