To frame the zombie epidemic as a “world war,” we acknowledge that there are two sides to this conflict, and that their respective goals clash with each other. While humans are concerned with preserving their race, the zombies are a unified unit waging total war, driven by their need to feed. In this situation, defense does not offer a permanent solution: we are only holding off the zombie forces temporarily, rather than decisively stopping the zombie epidemic. In fact, we grow weaker because every person we lose either dies, or becomes a zombie (and then dies again). The zombie population is made even more dangerous because they do not abide by the basic restrictions of being “bred, fed, and led” (Brooks 271).
Thus, if I were a head of state in World War Z, I would vote to go on the offensive, and attack the zombies with military forces. Because the zombie population is not held together by morale, it does not have a “maximum emotional psychology breaking point” (Brooks 273)—but the human population does. To circumvent this disadvantage, humans need to rally forces and eliminate the zombies methodically. Rather than wait for the zombies to slowly infect us all, we are now actively seeking them out and regaining control over the situation.
From a tactical standpoint, the army’s position and the amount of ammunition are crucial. A productive battle position is also a simple one: people are “massed in a straight line, two ranks: one active, one reserve […] Theoretically, with everyone either firing or reloading, we could keep Zack falling as long as the ammo held out” (Brooks 277). With enough resources, we not only outlast the zombies, but also ensure their defeat. By gradually killing each zombie and seeing concrete results, we also build morale, a crucial element to our success because we are fighting against enemies who do not need morale to keep going.
However, this approach raises questions about ethics. Although some argue that attacking the zombies is a death sentence, those who go into battle are aware that they may not make it out alive. Each person is “already a veteran in some sense” because “anyone who couldn’t roll wouldn’t have made it this far in the first place” (Brooks 276). A new, more experienced team can then be assembled, promoting both effectiveness and a sense of solidarity.
To successfully deal with the zombie crisis, humans need to work as a team.
If we think of the zombie crisis as an epidemic, it suggests that an “infection” is spreading. “Infection” is hardly a tangible foe, which makes it difficult for humans to fight together against this common enemy. If we think about the zombie crisis as a war, however, it implies that humans are fighting against their enemies—the zombies—and we are armed with “heart, instinctive, initiative, everything that makes us us” (Brooks 308). In the narrator’s interview with Todd Wainio, we see the impact this sort of spirit and morale-building can have. He states that after the battle (in which the plan to attack was implemented), “[i]t was different vibe, one-eighty from two days ago. I couldn’t really put a finger on what I was feeling, maybe it was what the president said about ‘reclaiming our future.’ I just knew I felt good, better than I had the entire war” (Brooks 282). The “war” Wainio describes here consisted of humans defending against zombies and fighting a losing battle. But now, we are waging a new kind of war—this time, with intention to actively eliminate our enemies. The concept of “reclaiming our future” is abstract, but by unifying the human population, it motivates us to keep fighting so that the human race has a future.
Resources:
- Brooks, Max. World War Z: An Oral History of the Zombie War. New York: Crown, 2006. Print.
- Photo of teamwork ()
One thought on “Regaining Control of Our Future”
Hi Evelyn,
I thought that your post is similar to mine in that we both take a weighted consideration of what it means to consider the zombie crisis as a war versus what it means to consider it as an epidemic. I very much agree that being able comprehend the idea of an end goal like “winning the war” is incredibly important for human morale. At the same time, however, your emphasis on the abstractness of “reclaiming our future” illustrates the paradoxical nature of this situation: although perceiving the conflict as a war might set a illusionary end goal in mind, actually realizing such a goal is impractical and perhaps impossible. To say that humans would eradicate all two billion zombies, in reality, is but a pipe dream. Perhaps victory could be regarded as the moment humans are able to find an end to their psychological suffering of living in constant fear, as mentioned in class, but again, the actual realization of such a moment may be different for each individual. I personally have difficulty seeing such a goal realized as a definitive victory. In my opinion, viewing the conflict as a war and going on the offensive may not have the purpose of ever having an end goal in mind. Simply the perception of such a goal could just be a tool for governments to make a step in the right direction, without regards to whether humans may truly reach a definite victory.