The 2018 Camp Fire ripped through the town of Paradise, California, in a matter of hours, killing at least 85 people, destroying 95 percent of the town’s buildings, and leaving 35,000 residents displaced.
Two years later, Community Housing Improvement Program (CHIP) is finally able to begin rebuilding its 36-apartment Paradise Community Village. It will be one of the first major residential reconstructions, providing needed affordable housing to the area, which has struggled to meet housing demand generated by the displacement, as well as from workers who have come in to rebuild.
“This day of celebration was a long time coming. We’ve faced so many hurdles getting here, and there were times when we thought we’d never be able to rebuild; that we’d never be standing here. There are still some challenges that we face. But we have seen the power of partnership, and what we can accomplish and what we can do together. We know we will overcome and be able to build this project,” Seana O’ Shaughnessy, President and CEO OF CHIP said in the Facebook Live-streamed groundbreaking ceremony.
“It’s a great addition to our community. The town of Paradise really needs this type of housing, now especially after the fire. We do need to have affordable units that are safe and decent and wonderful places to live. If anyone can make this happen, it’s [CHIP],” former Paradise Town Manager Lauren Gill said on the livestream. “I’m so happy they are going to rebuild the project in Paradise.”
Sen. Dianne Feinstein toured the community after the fire, surprised by how widespread it was. She realized how unpredictable fire is. “I want to salute you all for being so strong, and I want you to know you have a supporter here in the Senate, and I will help you with anything you need,” Sen. Feinstein said.
Rep. Doug LaMalfa said, “We know the need for more housing that is affordable is extremely important, and getting people back up on the ridge to their homes.”
The new complex will replicate the original and be rebuilt by the original general contractor. It will feature the same mix of one- to three-bedroom apartments with affordability from 30-60% AMI ($20,000-$40,000 for a family of four.)
CHIP will finance the reconstruction mainly from insurance settlement proceeds, as well as FEMA funds and private donations. While the bulk of the insurance settlement funds were already received, CHIP was still negotiating with the insurer for the remaining $2 million they expected to receive. CHIP reached out to NeighborWorks Capital and requested a $2 million line of credit to ensure it had additional funding available to cover construction costs in the event of either a short-term delay or payment being held until the project is finished. NC underwrote and approved the request in 28 days, understanding the urgency needed to keep the new construction on pace.
The development has received a great deal of support, between grant funds, donations, technical assistance and project approvals from the county, FEMA, the local community, and other local nonprofits. They have HOME, LIHTC, and AHP subsidies for the project. Major donors and the county have said they would provide further additional funds if there are any cost issues.
Completed in 2013, Paradise Community Village was the town’s largest affordable apartment development. It burned to the ground during the Camp Creek Road Fires in November 2018, at the time the deadliest and most destructive in California history, and the most expensive global natural disaster that year in terms of insured losses. The fire occurred when California was already impacted by a housing crisis, with low vacancy rates and ever-increasing costs to rebuild. Regionally, there is tremendous need for affordable housing, now more than ever.
The effort to rebuild Paradise Community Village was delayed by the community-wide devastation. Since the fires, CHIP has completed nearly 20 months of debris removal, clearing the property’s water of contamination, navigating the FEMA process, finalizing the plan update and review, and completing the procurement process. While work on the project began in late July, unfortunately, a recent groundbreaking ceremony was delayed due to another fire in the area.
In addition, destroyed property built using LIHTCs needs to be rebuilt in two years, or the government will recapture the tax credits. For Paradise, that deadline is this December, and CHIP requested an extension, hearing nothing for months. The IRS finally sent a letter of denial – the day of the first anniversary of the fire. CHIP has continued appealing to the IRS for an extension.
In 2015, CHIP borrowed a $1.2M land acquisition loan from NeighborWorks Capital for their Fox Run 2 project. In early 2019, they also borrowed a $300k Federal Funding Interruption Bridge Loan to keep construction moving on self-help housing development.
ABOUT CHIP
Originally founded in 1973 as a partnership between CSU Chico and the City of Chico, CHIP’s original purpose was to improve a small neighborhood south of campus through a housing rehab program. In 1980, they diversified operations by becoming a USDA Self-Help Housing grantee and expanded to several counties. In 1991 CHIP changed their name to Community Housing Improvement Program, Incorporated. CHIP is based in Chico, California and provides healthy, sustainable, affordable housing to qualified residents in seven North Valley counties. It has built nearly 2,000 single-family homes and over 700 rental homes and apartments and is acknowledged as an innovator and leader in affordable housing issues in rural and urban areas.