Edmund Grindal and His Letter to the Queen
Ed.
The unwelcomed reminder came at the end of a 6000-word letter (an actual “book to the queen”), fashioned after the epistles of Ambrose to Emperor Theodosius. The occasion was Elizabeth’s opposition to a practice known as “prophesying.” It was a common practice in England, imported from Frankfurt by returning Marian exiles. It could be described as “teamwork preaching,” where a group of preachers covered different parts of a sermon (for example, explanation, doctrine, and application).
If this sounds odd today, it made sense at a time when a sermon could last two or three hours. It was also a helpful tool in order to train new preachers. This is how Grindal saw it, at a time when England suffered from a scarcity of capable preachers and many inexperienced or unqualified men resorted to reading from the pulpit other preachers’ sermons.
The queen disagreed. The reports she had received of this practice made it sound like a disorderly ordeal. Grindal’s resistance to her requests to suppress it didn’t help. In the end, she ordered the archbishop not only to ban the habit, but also to limit the number of licensed preachers (for financial reasons, since they were supported by the state). Four or five per county were sufficient, she thought.
“But surely I cannot marvel enough,” Grindal replied, “how this strange opinion should once enter into your mind, that it should be good for the Church to have few preachers. Alas, Madam! Is the Scripture more plain in any one thing, than that the gospel of Christ should be plentifully preached, and that plenty of labourers should be sent into the Lord’s harvest, which, being great and large, standeth in need, not of a few, but of many workmen?”[1]
The 56-year old archbishop was well aware of the likely consequences of this challenge to the queen’s orders, but he was bound by his conscience and by God’s word which, he believed, gave him “no power to destroy, but to edify.”[2] “Bear with me, I beseech you, Madam,” he concluded, “if I choose rather to offend your earthly Majesty than to offend the heavenly majesty of God. … Remember, Madam, that you are a mortal creature”[3]
Unlike the Roman bishop he had taken as example, Grindal didn’t prevail over the queen, who had a hard time settling for a suspension and continued to press for a full demotion.
Grindal’s Life
By that time, Grindal had lived a long life of devotion to the gospel. Born in a farming family in the extreme northwest of England, he had studied at Cambridge, where he had turned to Protestantism while reading some writings by Heinrich Bullinger.
He had moved to Germany during the reign of Mary I and was at Frankfurt when a division started between those who agreed with Richard Cox in supporting the adoption of the Book of Common Prayer and those who agreed with John Knox who fiercely opposed it. Grindal, who had learned moderation from Martin Bucer, his professor at Cambridge, sided with Cox in this matter.
After the ascension of Elizabeth to the throne, Grindal returned to England where he rose surprisingly quickly from bishop of London to Archbishop of York to his final post as Archbishop of Canterbury. His friendship with William Cecil, the queen’s chief advisor, played a part in this rapid advancement, but Grindal’s virtues and abilities spoke for themselves. Archbishop Matthew Parker was still breathing when Alexander Nowell, dean of St. Paul, suggested Grindal as his successor, describing him as “a man of the greatest wisdom and ability to govern, and unto whom the other bishops with best contentation would submit themselves.”[4]
He was right. Even the Puritans who had fiercely protested Parker’s archbishopric felt at peace under Grindal, in spite of his moderate approach. Overall, he shared the Puritans’ concerns but exercised prudence in addressing them. For example, he asked for the destruction of crosses and altars, but tolerated the use of vestments.
His archbishopric didn’t last long. His disobedience to the queen caused him to be suspended almost two years after his appointment. His duties were delegated to compliant clerics such as John Whitgift, who opposed the prophesying movement.
Grindal retired to his manor at Croydon, still hoping for a pardon, while the queen attempted to deprive him of his position altogether. Many supported her in this desire, as they were eager to appoint another man to the archbishopric. Their attempts were repeatedly frustrated, as he failed to appear to repeated summons because of his poor health. He was tried in absentia, with the prosecution addressing an empty chair, and the queen didn’t have the heart to pass a sentence on man who was not present.
Grindal died in 1583, six years after his suspension. He devoted his last years to supporting the schools he had started or championed. His biographers have been surprised by the meagre possessions he owned at his death, compared to other people in his position. Most of his income had been devoted to causes he held dear, such as education.
Grindal has been remembered with respect and gratitude by Puritans and nonconformists. He even gained the praise of some who were notoriously anti-clerical, such as the poet John Milton. Some Anglican clergymen shared a different opinion. In 1707, for example, the Anglican preacher Henry Sacheverell described him as a “false son of the church” and “a perfidious prelate,”[5]
After Grindal’s death, the Archbishopric of Canterbury went to Whitgift, who was intolerant of Puritans and sent many to prison or exile. Whitgift maintained Elizabeth’s vision of limiting the number of preachers, allowing ministers to hold a pastorate in more than one parish. For this reason, many churches had to rely on curates to read state-approved homilies in the place of preached sermons. This in turn exacerbated the frustration of Puritans, hastening the protests and self-imposed exiles that characterized the following century.
[1] William Nicholson, ed., The Remains of Edmund Grindal, D.D., Cambridge: University Press, 1843, p. 378,
[4] Patrick Collison, Archbishop Grindal, 1519-1583, The Struggle for a Reformed Church, University of California Press, Berkley and Los Angeles, p 221.