Austin, Texas – As Austin debates its vision for public safety, a new report released today lays out the role Austin Regional Intelligence Center, also known as ARIC, plays in the surveillance and data sharing of Austinites. The Silicon Hills Eyes: How ARIC Fusion Center Surveillance Makes Austin Less Safe, is a joint project by Grassroots Leadership, Just Futures Law, and the Boston University School of Law Immigrants' Rights and Human Trafficking Program.
The report examines the technology ARIC uses to carry out its surveillance, the kind of information ARIC knows about the general public, the corporations and law enforcement agencies involved, as well as how this infrastructure harms some of Austin’s most vulnerable community members—including activists, immigrants, and students.
Key findings from the report include:
—ARIC conducts invasive surveillance on a wide array of Austin residents through a web of high-tech surveillance and data-sharing contracts, as well as in-person monitoring.
—ARIC uses city resources to share personal information of vulnerable Austin residents - including students and immigrants - with federal agencies, placing them at greater risk of arrest, detention, and deportation.
—ARIC has refused to abide by even the weak oversight mechanisms and civil liberty protections proscribed in its policy.
Authors of the report note that high-tech surveillance and data-sharing networks like ARIC that seek to preemptively monitor and profile people’s behavior and whereabouts are no longer confined to works of fiction like George Orwell’s 1984, but are increasingly a reality in many Black, brown, and poor neighborhoods.
Report recommendations include moving funding from the ARIC Fusion Center towards funding for immigrant legal defense through the Travis County Public Defender’s Office. The report also recommends establishing a mandatory Equity Office oversight process prior to consideration of city procurements, grants, and Council agenda items pertinent to public safety, as proposed by the Reimagine Public Safety Task Force. Not only would these initiatives begin to remedy some of the harm that ARIC has caused to vulnerable community members, they would also prevent the same threats from resurfacing through other surveillance and information sharing proposals.
The report follows the recent release of a budget proposal from the City Manager’s office that increases funding to the Austin Police Department by $8.5 Million compared to the 2019 budget, including transferring all items placed in the Reimagine and Decouple funds in last summer’s budget process back into the APD budget. ARIC was one of the units that had been placed in this fund after community alarm over its invasive surveillance practices, but is now slated to return to APD for continued funding.
Only $1.9 Million is allocated in the City Manager’s budget proposal for items recommended by the Reimagine Public Safety task force, despite robust proposals to fund programs that would remedy inequities in overpoliced communities. On Monday July 12, Communities of Color United, Grassroots Leadership, and Texas Harm Reduction Alliance demanded that the following be funded in this year’s budget proposal instead of increasing police funding above the levels required by law:
—Community neighborhood hubs
—Universal basic income pilot program
—Community health workers
—Mandatory equity oversight process prior to consideration of city procurements, grants, and Council agenda items pertinent to public safety
Claudia Muñoz, Co-Executive Director of Grassroots Leadership: “ARIC claims to protect the public, but that’s impossible to achieve through surveillance. In reality, ARIC creates a network of information that empowers the police state to continue its criminalization and persecution of Black and brown communities. Instead of continuing to fund ARIC surveillance and data sharing, we urge the City of Austin to shift funding toward initiatives such as community hubs, public health workers, universal basic income, and immigrant legal defense that will actually keep our communities safe.”
Paromita Shah, Executive Director of Just Futures Law: “It is impossible to maintain this surveillance and data sharing infrastructure without violating our core human rights and civil liberties. Its existence threatens all residents’ rights to privacy, freedom of speech, and movement. ARIC poses tremendous risks to Black and immigrant Austin residents to criminalization, arrest, and deportation. “
Professor Sarah Sherman-Stokes, Clinical Associate Professor of Law at the Boston University School of Law: “What we’re seeing here is the damage caused by ARIC in distributing sensitive, personal and identifying information to other local and federal agencies, including Immigration and Customs Enforcement. It increases exposure of Austin area residents to deportation while also subjecting all Austinites to unprecedented levels of police surveillance in their daily lives.”
The full report can be found here.
###
Grassroots Leadership is an Austin, Texas-based national organization that works for a more just society where prison profiteering, mass incarceration, deportation, and criminalization are things of the past. Follow us @Grassroots_News.
Just Futures Law (JFL) is an innovative legal organization that defends and builds the power of immigrants’ rights and criminal justice activists, organizers, and base building community groups working to disrupt and dismantle our deportation and mass incarceration systems.