Back to top
Whether building bridges or breaking dams, civil society is crucial when dealing with drug, crime or terrorism, writes Yury Fedotov, Executive Director of the United Nations Office on Drugs and Crime (UNODC).
Many civil society organisations provide important research, do valuable field work and make a sizeable contribution to policy development in the area of problem drug use. Therefore, the UNODC sees civil society, as an equal partner. It needs to be listened to and respected for its expertise.
Although the driving force behind UNODC’s work are the UN Conventions on drugs, crime and corruption, as well as the international instruments on terrorism, our ability to deliver on this mandate is often reliant on civil society organisations. For this reason, UNODC has developed many years of engagement with them. The importance of the relationship is heavily emphasised in our Strategy for 2012–2015 and translates into close working relationships in the field. Indeed, UNODC works with numerous organisations across the world on a wide range of activities.
These activities include work on alleviating the suffering of people who use drugs and their families; we also work together on empowering the victims and witnesses of crime. Elsewhere, we are strong partners with civil society in the fight against corruption and the need for effective criminal justice systems.
Just as importantly, this collaborative work is regularly carried out in difficult environments. We are often in weak and fragile nations, especially countries that have only just escaped from conflict and which are slowly moving along the path towards democracy.
I should add that such joint activities also represent the wishes of Member States who believe in the importance of transferring knowledge, skills and information across organisations in order to enrich their operations. Such activities are vital to ensure good policy is bound to sound operations.
The converse, however, is also true. For operations to succeed, they must also be driven by prudent policy. This is why the Commission on Narcotic Drugs (CND), and UNODC’s secretarial role for the drug conventions are so important. The annual CND is also enhanced by civil society’s participation as observers.
UNODC has also established effective working partnerships with umbrella organisations such as the Vienna NGO Committee on Drugs (VNGOC). They allow for coordinated and effective civil society participation in the CND, while bridging the gap that often exists between international policy-makers, national authorities, and civil society.
Civil society has also provided excellent contributions to the high level segment of the 2009 CND through the “Beyond 2008” project, undertaken jointly by UNODC and the VNGOC. The event gave a platform to 900 people representing thousands of organisations within their networks and millions of members in around 145 countries.
There are other situations where the voice of civil society has made a difference. Some civil society organisations, for example, have shown how the drug conventions have been overruled in some countries producing greater suffering for cancer patients due to shortage of opiates available to alleviate their pain. The campaign led to a CND resolution aimed at addressing this gap, and it shows how policy can be successfully allied to experience in the field.
I would also encourage civil organisations to continue to be the eyes and the ears of society and to constructively contribute to the CND. I participated in the first informal Civil Society Hearing during the 2012 Session of the Commission CND and I am planning to do so again this year.
The meeting provides a welcome space where civil society, UN Member States, and key international bodies can exchange views and discuss best practices in the area of drug policy. It is likely that this year the focus will be on civil society contributions to the 2009 Political Declaration and Plan of Action. With this in mind, UNODC will continue to support the work of civil society and to take an active role in promoting the dialogue between civil society and Members States.
Whether building bridges between organisations, or breaking the dams that hinder their effective action, civil society organisations play a leading role in the area of drugs, crime and terrorism. Over the years, mutual suspicion has given way to mutual respect to everyone’s mutual benefit. Today, civil society is listened to and much admired wherever it works.
My role, as head of UNODC, is to ensure that our enduring partnership continues on this path and delivers assistance to the millions of people around the world who need us most.
An new international indigenous network for drug law reform was launched on 27 November at Healing Our Spirit Worldwide – The Eighth Gatheri......
Learn about recommendations from the Global Commission on Drug Policy in it's new report "Regulation: the responsible control opf drugs"...
The Government has announced they will not go ahead with plans to build a “mega prison” at Waikeria in the Waikato....
The next UNGASS on drugs has been brought forward from 2019 to 2016. That's still a year away, but at a UN level, this amounts to blisterin......