Thought Leadership
What Global Mobility Management Means to Talent Acquisition
New hires who must relocate aren't like other employees.
By Brynne Kennedy.
Underestimating Retention's Importance
It would be hard to overstate the importance of candidate experience to recruiting. As such, most companies (59 percent) are increasing their investment in creating a seamless, consumer-like applicant experience.
Today that means simplifying application processes and optimizing for mobile. From our work to what we do on our weekends, most of our lives are managed on our mobile phones. In retail, a slow or complicated user experience can lead to 58 percent of users abandoning their shopping carts before checking out. In recruiting, it results in a huge drop in the number of candidates actually completing applications. That's why 39 percent of companies are working to optimize their career websites for mobile, and 36 percent of companies are adopting a mobile-first application process.
But while companies are investing in recruiting, they aren't devoting adequate resources to candidates' experience after they're hired. According to LinkedIns Global Recruiting Trends research, only 32 percent of global talent leaders view retention as a top priority; that's mind-boggling when you consider the investment made in attracting talent in the first place.
Employees increasingly expect the same customer-like experience they enjoyed as a candidate, especially employees who must relocate for a new position. Unfortunately, most companies and talent acquisition leaders still struggle to piece together disparate, ad-hoc systems, which ends up putting an extreme burden on the new hires and their families relocating for the company, as well as putting added pressure on talent acquisition and HR to play "relocation consultant." Consider the last move you made, for example. Even if you were relocating to a different neighborhood in the same city, you still had to worry about finding a buyer for your old home, checking out new schools for the kids, switching utilities, registering your kids in new schools, hiring and overseeing movers, and myriad other things. Now imagine doing all that in a foreign country where you may not speak the language, on top of adjusting to a new job at a new company. By failing to devote enough attention to helping new employees adapt to an unfamiliar environment, you'll decrease their readiness to take on their new role, reduce their productivity from day one and create early stage flight risks.
The Solution: Be Rigorous
How can you avoid this scenario from taking place at your company? First, centralize how you manage moves. By creating a concrete framework or instituting technology for helping new hires deal with the enormous complexities of relocation -- obtaining the proper paperwork and visas, finding housing and dealing with cultural barriers -- and settle into their new lives as expats, you'll ensure that nothing gets lost in the shuffle while freeing employees to focus on their new roles.
This is equally important for employees who relocate for short-term assignments.
Second, train your recruiters on the complexities and tax ramifications of relocation and how it will impact compensation. Candidates need this information in order to fully vet opportunities.
Finally, formalize the details of how your organization supports its workers. Make sure your employee handbook spells out how you handle compensation, hardship bonuses, housing allowances and trips home.
The Bottom Line
Talent mobility is no longer an exception; it continues to become the norm. And given the complexity of global mobility management, we've only scratched the surface in this article. Centralized, formal systems of oversight and employment/immigration law training for corporate recruiters and hiring managers are critical to supporting the successful hiring and onboarding of desirable talent, but that's just the beginning. Giving candidates who must relocate the fair and consistent treatment they deserve requires you to secure company-wide commitment and investment. Not easy, but it's worth it, and will result in a more positive onboarding experience, more productivity from new hires and better ROI from your recruiting efforts.
Brynne Kennedy is founder and CEO of MOVE Guides. A frequent speaker and author on topics of technology, HR and global mobility, she previously worked at Lehman Brothers and Standard Chartered.