The Fight for a Self-Evident Truth
Around 400 B.C., the Greek playwright Euripides’s “Medea” strongly felt the disadvantages of being a female: Of all creatures that can feel and think, we women are the worst treated things alive.
Over 2,000 years later, this sentiment of discontent continued in America.
Seneca Falls is a sleepy town in upstate NY, lined with century-old homes and surrounded by landscapes of lush green fields, miles of corn and vineyards, and a splattering of lakes and farms. In many ways, it’s no different than any of the other surrounding towns and villages.
A quaint Main Street is home to a couple of bars and the VFW, and the surrounding homes have stood for well over 100 years. The Erie Canal National Heritage Corridor provides locals with a spot to fish or the chance to bike along the water. Despite its calm, small-town feel, the history of Seneca Falls stands out at Women’s Rights National Historical Park — the birthplace of the women’s rights movement in America.
As unlikely as it may seem today, in the early 1800s Seneca Falls was a center for reform. It and the surrounding area were known for its influx of progressive ideas, as the Erie Canal brought both new goods and philosophies to the area.
Perhaps most notable among the emerging ideologies in the area was the religious zealotry, which inspired such undertakings as the Whitman mission in Oregon. Attending church was a large part of communal interactions, as it was one of the few acceptable opportunities for socializing. Often, the women would meet afterwards to chat together — getting out of the house and leaving their chores and wifely duties for a few hours. In time, the chatter turned to expressing frustrations over their position in society.
Many of the inhabitants of the area were Methodists or Quakers, a group that stood at the forefront of the reform movements of the time, from temperance to abolition. Some of the houses in the area, including the M’Clintock home in nearby Waterloo, were even part of the Underground Railroad. The Quaker belief in equality and open-mindedness toward societal changes created an environment ripe for discourse on the role of women.
Over tea in the Hunt home during the summer of 1848, Jane Hunt, Lucretia Mott, Elizabeth Cady Stanton, Mary Ann M’Clintock, and Martha Coffin Wright planned the first women’s rights convention. A week later, on July 16, 1848, the women met again, this time at the M’Clintock home. Here Elizabeth Cady Stanton and the other women present drafted a list of grievances, formatting it after the Declaration of Independence.
The Declaration of Sentiments sought to provide women with the same citizenship rights guaranteed to men, even demanding the right to vote — an idea so radical that Lucretia Mott protested its inclusion. The two-day convention began on July 20, 1848, and the next day, the declaration was signed by 68 women and 32 men, including Frederick Douglass. It signaled the start of the women’s rights movement in the United States.
Over 300 people attended the convention and two weeks later, another convention was held in Rochester. Soon, similar events sprung up in other states and by 1850, cohesive networks of people committed to furthering the rights of women were formed. Once the Civil War ended, official women’s suffrage organizations were also created, though they would not make significant strides toward their goals until the 1900s.
Visiting Today
Driving through Central New York today, visitors can explore several of the significant sites where the leaders of the women’s rights movement met and lived. Begin in the visitor’s center to watch a short film and to see the iconic and almost life-sized bronze statues of some of the most important voices of activists from this first wave of women’s rights. Beside the center is a green area where visitors can read the declaration and its signatures, which are etched into a 100-foot bluestone waterwall.
Next door stands the rehabilitated Wesleyan Chapel where the convention was held. Though the church has since been used in a number of ways (a public meeting house, movie theater, repair shop, etc.) and was worn down due to weather-related damage, work to protect this iconic site was undertaken in 2009. This restoration project was difficult, as no pictures remain to indicate the church’s original appearance during the mid-1800s, but preservation efforts created a quiet space for visitors to reflect on the movement.
Visitors can take a short drive to the Stanton House — a small white home where Elizabeth Cady Stanton lived with her husband and 7 children between 1847 and 1862. Imagine the change for Stanton as she moved to this remote home, surrounded by the canal and greenery, from Boston — the intellectual hub where Stanton had previously lived.
Elizabeth Cady Stanton House
Wrap up your trip by heading to nearby Waterloo, where you can see the Hunt house. It was at an afternoon tea here that the idea to host a women’s rights convention was born. Then explore the M’Clintock home, a stop on the Underground Railroad and the location where the women began drafting the Declaration of Sentiments. Today, the table where the women sat and composed the revolutionary document can be found in the Smithsonian National Museum of American History.
Imagine a time when the idea of a woman even voting was considered too radical to discuss seriously. When. #FindYourPark/#EncuentraTuParque in Central New York to explore the area where herstory was made.
Start a Conversation