New Agents for Multiple Myeloma—Some Show Early Promise; Others are Ready for Prime Time
Highlights from the American Society of Hematology (ASH) Annual Meeting, December 8-11 2012
By Edward J. Gorak, DO, MS, FACP
The medical and scientific communities continue to advance our understanding of the pathophysiology of multiple myeloma. With that, new targets are identified and novel therapies are developed. The 2012 ASH Meeting was filled with a host of new targeted or “smart bomb” therapies for the treatment of multiple myeloma. The early showings of these agents are promising but not quite ready for prime time. Other drugs have moved into the prime time slot and continue to strengthen their position as single agents and in combination with other drugs in the fight against myeloma. Finally, some of the differences in our established therapies still find us with unresolved controversy.
Early Promise
Daratumumab is a monoclonal antibody that targets the CD38 molecule (a key surface protein on myeloma cells) and stimulates the immune system to kill myeloma cells. An earlier abstract from the American Society of Clinical Oncology (ASCO) June 2012 Meeting showed a 24% partial response in patients that had previously received multiple therapies (median of 6). The ASH update strengthened the drug’s ability to bind the CD38 target on myeloma cells. The drug was also well tolerated by patients.
Elotuzumab is another monoclonal antibody that is showing promise. This drug was also presented at ASCO 2012, where a Phase II study showed that elotuzumab in combination with lenalidomide (Revlimid) and dexamethasone (Decadron) demonstrated an overall response rate of 84%. An update at the ASH meeting reported that the response rate had improved to 92%. The patient population was typically older (median age=63 years) and the majority had received multiple prior therapies. These encouraging results have led to the development of Phase III trials in newly diagnosed and relapsed patients. Look for this drug to be in a prime time slot in the future!
A new novel agent, ARRY-520, acts by disrupting dividing cells through inhibition of kinesin spindle protein. A Phase II trial of ARRY-520 alone or in combination with dexamethasone was conducted in heavily pre-treated patients. Partial response rates in the single agent and combination arms were 16% and 22% respectively. These results warranted moving forward with further clinical trial development.
Prime Time!
Carfilzomib (Kyprolis) is a proteasome inhibitor that gained FDA accelerated-track approval in July 2012. The labeled indication is for patients that have had at least two prior myeloma therapies including bortezomib (Velcade) and an immunomodulatory agent such as lenalidomide (Revlimid) or thalidomide (Thalomid). The main toxicities of this drug are hematologic. Be aware of a small but potentially serious risk of cardiac and pulmonary complications. Carfilzomib is now being studied in combination with other established agents such as lenalidomide, dexamethasone, thalidomide, and cyclophosphamide. Additional studies with novel agents such as those mentioned previously are also underway. This new prime time drug should be in a favorable spot for years to come.
Pomalidomide (Pomalyst) was approved by the U.S. FDA on February 2013. This oral drug is in the class of immunomodulatory agents (lenalidomide and thalidomide). Like carfilzomib, this drug is now being combined with other agents and results have been impressive thus far. In particular, the combination of pomalidomide, carfilzomib, and dexamethasone in relapsed patients yielded excellent response rates. Expect a long showing of this drug as well.
Late-Night Controversy
The role of maintenance chemotherapy remains undefined in patients with multiple myeloma. Some previous studies have suggested a benefit whereas others suggest no benefit. Bortezomib-Melphalan-Prednisone-Thalidomide followed by Bortezomib-Thalidomide maintenance (VMPT-VT) was compared with Bortezomib-Melphalan-Prednisone (VMP). Notably, VMPT-VT prolonged overall survival. It is unclear if the true benefit in the VMPT-VT arm is due to maintenance therapy or the more intensive induction regimen. Notably, the VMPT-VT group experienced increased toxicity resulting in a discontinuation rate of 12%. The risk of secondary malignancy (SPM) is low with immunomodulatory agents (thalidomide, lenalidomide) but real. Physicians must balance efficacy with toxicity especially in the maintenance setting. The increased toxicity coupled with uncertainty about efficacy leaves maintenance therapy undefined. Stay tuned as the maintenance arena continues to evolve.
There has not been much talk about peripheral blood stem cell transplantation for multiple myeloma of late. Newer, efficacious and less toxic regimens have made transplantation appear less attractive in some circumstances. There continues to be controversy surrounding the timing of transplant, sequence of transplants (single autologous, double transplant, autologous-allogeneic), and the role of consolidation and maintenance therapy following transplant. Hopefully, we will see results from a large randomized trial conducted by the Blood and Marrow Transplant Clinical Trials Network (BMT CTN) that addresses these questions in an upcoming meeting.
Stay Tuned
In 2012 we saw some changes in programming in the care of the myeloma patient. Well-studied agents were brought into routine clinical practice and novel compounds completed pilot testing and are ready to assume a more active role. We look forward to new reasons to tune into the care of the myeloma patient in 2013.
Edward J. Gorak, DO, MS, FACP, is an associate in Hematology and Principal Investigator at the Geisinger Health System, Geisinger Cancer Institute, in Danville, Pa. Dr. Gorak is a member of the accrual working group for the NCI Myeloma Steering Committee. He is a member of the Advisory Board for ACCC’s Improving Quality Care in Small-Population Cancers—Multiple Myeloma education project.