Moose No. 18 was in trouble.
It was late December last year, just before Christmas, and researchers with the Minnesota Department of Natural resources were tracking the 8-year-old female in the forest near Isabella, Minn., using a satellite GPS collar they had placed on her five years ago.
But she was barely moving, and then she stopped altogether. So a crew headed north from the Twin Cities to investigate.
When they arrived, they could tell the moose had died within the past 24 hours, said Michelle Carstensen, DNR wildlife health program supervisor.
However, it seemed the moose had been in the same spot for a couple days, laying on her side, paddling.
"There was an indentation in the ground where her legs were kind of kicking away the snow and dirt, and she had been stuck there for a while before she passed on," Carstensen said.
As wolves had just began to scavenge the moose, researchers dragged her 740-pound carcass out of the woods and brought it to a veterinary diagnostic lab at the University of Minnesota.
There, technicians identified the killer: brainworm, a parasite carried by white tailed deer.
• Previously: U researchers raise money to investigate moose brainworm mystery
Moose No. 18 was the 60th and final dead moose researchers recovered during the high-profile project the DNR launched five years ago. That was fitting, Carstensen said, since she was also one of the very first moose they captured and outfit with a satellite GPS collar.
Those collars, placed on more than 100 adult moose, and nearly 50 calves, transmitted precise locations of moose when they died. Researchers received text and email updates at all hours of the night.
They used snowmobile, ATV, snowshoe and even amphibious vehicles to reach the moose before they were scavenged or decayed, so necropsies could be performed to determine precisely what killed the animal.
Carstensen said they were able to reach 70 percent of the moose within 24 hours, what she called an "unprecedented timeframe" for such large animals in such a remote area.
So, is Minnesota's moose mystery solved?
While researchers are still sifting through the data, "I can tell you that the thing that we learned the most is how complex the system really is," Carstensen said. "I think there was kind of an unreal expectation that we were going to be able to find a smoking gun. And prove definitively that X or Y are causing the moose decline."
Still, the results show the different factors that have contributed to the moose decline.
Of the 60 adult moose that died during the study, about 30 percent were killed by parasites like winter ticks and brainworm. Another 30 percent were killed by infections or other health issues.
Some 30 percent were also killed by wolves, although nearly half of those moose had serious underlying health problems, Carstensen said, "which explains why they were selected by a predator that's evolved to sense those things."
Moose calves were particularly vulnerable to wolves. A parallel study found that wolves were responsible for about two thirds of calves killed over the past five years. Many others were killed by black bear.
• Study: Isle Royale moose shrinking while their population booms • 2017: Moose population explodes on island park as wolves decline
"You need to be able to what we call recruit as many calves as possible, and have them survive to be a full year," said DNR moose project leader Glenn DelGuidice. "They're quite vulnerable when they're first born, and for their first month to 50 days especially."
A similar ongoing study by the Grand Portage Band of Lake Superior Chippewa reached similar conclusions.
About three quarters of calves killed during the study the band launched in 2010 were killed by wolves and black bear.
Out of about 120 adult moose outfit with satellite collars, 28 have died, said Seth Moore, the band's director of Biology and Environment. Of those, nearly 40 percent were killed by brainworm.
"That is a low hanging fruit from a management perspective in the sense that brainworm prevalence in moose is likely directly tied to deer population," Moore said. "So if we want to do something to improve moose in moose range, a starting place would be reducing deer density in the core moose habitat area."
That would not be a popular move among deer hunters. A recent survey found many didn't support reducing the number of deer in northeastern Minnesota, said the DNR's Carstensen.
"Deer hunters want to hunt deer. They like moose, they would like to have more moose, but not at the consequence of less deer. There needs to be commitment from our hunters and landowners that live there that this is important, and I don't think we're there at this point in time."
Another potential "lever to pull" to try to bring back the moose population in Minnesota is by managing wolf numbers through a state-sanctioned wolf hunt, like one that was held for three years, starting in the fall of 2012.
But that option has been off-limits since late 2014, when a federal judge placed wolves back under endangered species protection. That decision was upheld by a federal appeals court last year.
And additional research is still needed to determine what role climate change might be playing in the moose decline, Carstensen said.
An earlier study found a correlation between the moose decline in northeast Minnesota and warmer winters, but no direct cause and effect.
The DNR is currently retrieving the last of the research collars from moose that survived during the study period. Those collars contain data from implants that collected body temperature and other information from the moose.
Carstensen said that will give scientists insight into how moose responded physiologically to warmer temperatures and other weather conditions.
Moose numbers have stabilized in northeast Minnesota in recent years. After reaching a peak of nearly 9,000 in 2006, they've hovered around 3,000 for the past several years, including during the most recent survey released this week.
But Carstensen noted the same trend occurred in northwest Minnesota after numbers started to drop in the 1980s. They leveled for a time, before falling precipitously again. Now they've virtually disappeared from that corner of the state.
"I'm cautiously hopeful that we've leveled off," she said. "But I'm also realistic that it might decline even further in the next five years and mimic what happened in the Northwest part of the state."