HOW TO ESTIMATE YOUR TOTAL DAILY ENERGY EXPENDITURE (TDEE)
I have been getting a lot of questions lately about how someone can determine how many calories they are burning on a daily basis so I have laid out the steps in determining your Total Daily Energy Expenditure (TDEE) below.
Keep in mind that these numbers that you will calculate are really just estimates and not exact figures. You will have to continually adjust your calorie intake week to week depending on the progress you are making, or lack thereof.
Your TDEE is essentially your “maintenance” calorie intake – meaning that this is the number of calories that you would need to consume on a daily basis in order to maintain your current body weight.
Your total daily energy expenditure (TDEE) is comprised of 4 different inputs:
- Basal Metabolic Rate (BMR)
- Thermic Effect of Food (TEF)
- Thermic Effect of Activity (TEA)
- Non-Exercise Activity Thermogenesis (NEAT)
Basal Metabolic Rate (BMR) – the number of calories that your body would burn at complete rest in a 24 hour period while maintaining your body’s most basic functions like breathing, circulating blood, and growing and repairing cells.
Thermic Effect of Food (TEF) – the number of calories that your body burns through the processing of food for use and storage. This will typically somewhere around 10 to 15% of your total daily energy expenditure (TDEE). Each macronutrient has its own thermic effect with proteins having 20-30%, carbohydrates having 5-15%, and fats having 3-4%. Therefore, when you eat 4 calories from protein, roughly 1 calorie will be burned off through the digestion process.
Thermic Effect of Activity (TEA) – the number of calories that your body burns through intentional exercise. This could be running, jogging, biking, weight training, etc.
Non-Exercise Activity Thermogenesis (NEAT) – the number of calories that your body burns through movement that is not related to intentional exercise. This could be from fidgeting, shivering, twitching, walking around the house, etc.
These 4 components (BMR, TEF, TEA, and NEAT) are what make up your total daily energy expenditure. Now let’s move on and see how we can figure out these numbers.
The first step in determining your TDEE is to find your BMR. You can find your BMR using one of these formulas below. Again, each will come with a different number but these are just estimates and you can fine tune everything along the way.
Formulas:
- Harris-Benedict:
Men: 66 + (13.75 x weight) + (5 x height) – (6.76 x age)
Women: 655 + (9,56 x weight) + (1.85 x height) – (4.68 x age)
- Mifflin-St Jear:
Men: (10 x weight) + (6.25 x height) – (5 x age) + 5
Women: (10 x weight) + (6.25 x height) – (5 x age) – 161
- Owen:
Men: 879 + (10.2 x weight)
Women: 795 + (7.2 x weight)
- Other:
Men: 24.2 x weight
Women: 22 x weight
** where weight is in kilograms, height is in centimeters, and age is in years **
Once you have estimated your BMR, you will need to multiply this number by an activity multiplier. Activity multipliers depend on the type, intensity, duration, and frequency of physical activity. Energy needs for physical activity may vary from 20% to 70% or more of BMR.
Follow the guidelines below to determine your multiplier:
-
Once you have multiplied your BMR by your activity multiplier, you have successfully determined your total daily energy expenditure.
Let’s use an example to make sense of this.
Let’s say we have a 30-year-old, 6-foot tall, 200-pound male who is moderately active who is looking to determine what his daily calorie expenditure is. Let’s use the Mifflin St. Jeor equation is calculate his BMR:
(10 x 90.72) + (6.25 x 183) – (5 x 30) + 5 = 1906 calories
Now that we have his BMR of 1906 calories, we then need to multiply this by his activity factor of 1.55 to get his TDEE.
In this example, a 30-year old, 6-foot tall, 200-pound male who is moderately active would have an estimated TDEE of 2,954 calories.
There are a lot of things in which you can do with this number:
- Eat in this range of calories = maintain your current weight
- Eat more than this number = expect to gain weight
- Eat less than this number = expect to lose weight
Of course, in order to do it all correctly and improve your body composition, you will need the right deficit / surplus with the right macronutrient ratio.
More on that in a blog post to come in the near future! Stay tuned!