RightHand Robotics Inc. today announced raising $23 million in Series B funding. The Somerville, Mass.-based company, which makes robotic piece-picking systems, had previously raised $11 million in seed and Series A investments.
“This funding is a testament to our team’s intense focus on solving the critical challenge all our customers face — namely, how to respond to booming e-commerce growth, given a scarcity of labor,” said Leif Jentoft, co-founder and CEO of RightHand Robotics. “We are aggressively investing in talent acquisition, international growth, and advancing our RightPick product line to meet these needs.”
“We have been continually impressed by RightHand’s customer traction and industry track record, with deployments in North America, Japan, and Europe,” said Mark Siegel, a partner at Menlo Ventures, who will be joining RightHand’s board of directors. “What inspired us to invest were the testimonials we heard from customers who have used RightHand’s technology and rank it highly with respect to range, rate, and reliability.”
“Menlo Ventures has also invested in 6 River Systems and is bullish on the robotics industry,” said Vince Martinelli, head of product and marketing at RightHand Robotics. “We’re a key part of the puzzle as they see it.”
Other investors in this round include GV (formerly Google Ventures) and previous supporters Dream Incubator, Matrix Partners, and Playground Global.
“RightHand Robotics developed a comprehensive, integrated solution that resonates with a wide variety of e-commerce companies,” said Andy Wheeler, general partner at GV. “The founding team of roboticists at RightHand has the right expertise, a full-stack product, and the overall vision to make an impact on this growing market.”
The company was founded in 2014 by winners of the DARPA Autonomous Robotic Manipulation challenge. Employees have come from MIT, the Harvard Biorobotics Lab, the Yale GRAB Lab, and iRobot.
RightHand’s staff has doubled in size in the past two years to 40 people, and its RightPick product debuted at ProMat 2017.
More than just a gripper
RightHand Robotics is more than just a gripper, Jentoft told Robotics Business Review during a recent site visit. Its all-in-one, piece-picking system includes off-the-shelf robots and cameras, as well as its own integrated software.
The demonstrations at RightHand’s headquarters used UR5 and UR10 collaborative robot arms. However, the type of the arm is driven by customer requirements for reach and speed, explained Martinelli. The company’s grippers and software also work with robots from KUKA and Yaskawa, among others, he said.
RightHand’s system works with Tompkins Robotics’ t-Sort for unit and parcel sortation.
RightPick works with AS/RS systems such as this one from OPEX. Source: RightHand Robotics
In addition, RightHand’s systems work with other automated storage and retrieval systems (AS/RS), such as those from OPEX, Jentoft said. The company’s software also works with warehouse management systems.
Machine learning and the API (application programming interface) layer enable RightHand to sort mixed items that it hasn’t seen before.
“One site can have 250,000 SKUs. With suction cups and fingers, RightPick can serve most e-commerce facilities,” Martinelli said. “We’re shooting for no human intervention, or Level 4 autonomy.”
Picking for peak demand
Warehouses don’t have enough people for all the transition points, said Martinelli. He cited the example of a Halloween costume company in Minnesota that had to recruit workers who live one to two hours away for a “peaky” business, where 25% of orders occur in a brief part of each year.
“We can help get optimal performance from humans and robots,” he said. “Some companies are solving only a piece of the puzzle, such as AI or vision.”
“Our system is agnostic in the sense of cameras and can include bar-code scanning,” noted Martinelli. “RightPick is learning how to put things in totes.”
At a DHL event, RightPick achieved a pick rate of 800 to 1,000 units per hour. It has worked with assembling food kits and cosmetics, as well as with third-party logistics (3PL) providers.
“This past year, we set a world record of 100,000 picks at Modex, and we’ve had successful head-to-head ‘bakeoffs’ in Germany, Japan, and the U.S.,” Martinelli said.
The company has partnered with Capacity LLC for fulfillment solutions and with Vecna Robotics, which makes autonomous mobile robots.
“Mobile manipulation requires a true collaborative mix,” Martinelli said. “While big facilities can be redesigned to accommodate Kiva, smaller retailers have a competitive set of solutions.”
Kiva’s Mountz joins RightHand’s board
Mick Mountz, founder and former CEO of Kiva Systems, will also be joining RightHand’s board of directors. Amazon bought Kiva in 2012 and has renamed it Amazon Robotics.
After spending 13 years in high-tech product development, manufacturing, and marketing at Motorola, Apple, and Webvan, Mountz founded Kiva in 2003, specifically to solve the picking, packing, and shipping material-handling challenges of e-commerce.
“RightHand is picking up where we left off,” he said.  — mastering the critical performance requirements of real-world distribution center environments,” Mountz added. “This funding round enables a very exciting phase of rapid rollout and scale-up for the company.”
Posting growth
RightHand Robotics is based in a former post office in Somerville’s Union Square. The company can take advantage of the Boston area’s pool of technology talent and expects to grow.
“As soon as you raise money, expectations go higher,” Martinelli said. “We’re definitely going to be posting new positions and hiring people. We have to scale. We’ve been pulled into international projects with some customers, so we need to invest in international growth.”
“We’re also continuing product development. We’ll make a series of improvements and add capabilities to our products,” he said. “We’ll be adding people to support that.”
Note: Editor Keith Shaw contributed to this article.