The world of broadcasting is in constant flux, with undefined boundaries between broadcast, TV, film and interactive media. With a changing consumer demographic now a key influence on the industry, many companies no longer specialise in a single medium, but have had to become adaptable to deliver multiple services through a combination of media.
Within the industry, competition for newly graduated broadcast professionals is fierce and getting a first job is undoubtedly the toughest step. Anyone in modern day studies will know that getting a job in broadcast or media is not about waiting until after graduation, it’s vital to start building knowledge, contacts and experience while studying.
New entrants to the working world of broadcast will need to develop a technical foundation, whilst being able to demonstrate multimedia awareness, and more general commercial and legal knowledge. With such a plethora of avenues into the broadcast industry, it’s also important that companies in the industry take a level of responsibility for enabling students to be as prepared as possible for what to expect after graduating.
One industry heavyweight that is taking its social responsibility to the next level is NEP UK. NEP UK started its Student Open Day’s four years ago to address the lack of talent coming into the industry. Held at their Bracknell headquarters in October, NEP UK welcomed over 450 students from universities, colleges and sixth forms across the country, including the local Bracknell and Wokingham College, the University of Surrey, Solent University and The Liverpool Institute for Performing Arts.
NEP UK’s marketing manager Kayte Burns, said, “we were aware of the lack of people and skills needed for the future and recognised this as a challenge facing the entire industry. This formed the motivation behind the open day; a desire amongst industry leaders to encourage budding engineers and technologists towards the industry and to help them to understand the pathways available.”
NEP UK’s warehouse became home to a host of student experiences focusing on the technologies that they could be using on a daily basis. Attendees were able to get hands on in OB UHD and IP vehicles and uplink trucks, use fixed and overhead wire cameras, practice swooping shots with a jib, and talk to the engineers and operators in these roles. Students could also attend mini workshop on the basics of intercom and connectivity for OB applications.
Students were treated to a full day conference of speakers from every walk of the industry, focusing on developing the thoughts and minds of an increasingly diverse spectrum of workers within the broadcast industry – most importantly from the perspective of gender and ethnicity.
After a welcome speech from president for NEP UK and Ireland, Steve Jenkins, the conference began with a presentation from the BBC’s Peter Taylor, production engineering manager, gave an insight into how the BBC lays on OB’s for some of the most famous UK music festivals, including Glastonbury and Reading. Inga Ruehl, Sky Production Services’ head of studios also presented an inspiring talk on Sky and its career initiatives for young people today.
Sadie Groom, managing director of Bubble Agency, the global PR, marketing and events agency specialising in the media and entertainment technology and services sectors, delivered an all-round insight into the do’s and don’ts of interviews, and how best candidates can present themselves to prospective employers.
Groom is also the founder of Rise for Women in Broadcast, a not-for-profit, advocate group for gender diversity within the broadcast manufacturing and services sector. Rise launched its first UK-based mentoring scheme for women in February 2018, and alongside Groom, a selection of the mentors and mentees, including Anna Patching, a sound engineer at OBStv (part of the NEP Group) spoke on a panel dedicated to opportunities for female broadcast professionals.
Anna Ward, head of production at Premier League Productions, advised on staging an approach into the broadcast workplace. “Be clear on what you want to do; you will get knock-backs, everyone does, but you’ve got to have a thick skin. Definitely capitalise on the opportunities you’re given.” Fellow panellist, Sky’s Inga Ruehl, also said: “It’s never been a better time than now to be a woman getting into this industry.”
Bob Clarke, CEO of Mama Youth Project, a charity that trains young people from under-represented backgrounds to succeed in the media industry joined another panel on Diversity and Inclusion in the Media Industry panel. Clarke commented on changing stereotypes in broadcast, stating, “if we get it right in this industry, by default it’ll rub off into society”.
As well as a two-stream conference, NEP UK gathered many of its partners together to provide students with information on what their companies offer in terms of work placements, training and job roles. Those present included newly acquired NEP company, SIS, plus For-A, Ross, Grass Valley, Creative Technology, and Clear-Com, NEP Bow Tie, Ross, Vislink, EVS, Sony, Grass Valley, Techex, Panasonic, Calrec, Lammo and Luna Remote Systems.
NEP UK have created multiple initiatives a result of the feedback from the Student Open Day, including the NEP UK and Ireland Mentoring programme, which launched following the event. NEP also recently supported a Women in Broadcast mentorship scheme via RISE and are also a Talent Pool Member for Mama Youth – both which offer tangible opportunities to young people coming into the broadcast industry.
NEP’s Katye Burns concluded that she hopes to expand and broaden the event for 2019. “This was our biggest Student Open Day to date, and moving forward, NEP hopes to partner with even more new enterprises that address the skills gap in the broadcast industry to take the event to the next level. Our industry faces unique challenges, and the more people creating opportunity for the young technologists, engineers and broadcasters of the future, the.