Albert Einstein had very humble beginnings. He was born in Ulm, Germany in 1879 to an engineer/ part-time-salesman and a housewife. Many people with an advanced level of intelligence oftentimes displayed peculiar habits, trends or rituals as children. Things like hypersensitivity, well-developed powers of abstraction, unusual or vivid imagination and a series of other quirks have been traditionally seen to color a genius’s childhood. This was not the case with Albert Einstein. The only peculiar trait Einstein displayed as a child was his aversion to talking. He spoke very little and was effectively mute until somewhere around age 7. In response to such preconceived notions, many popular myths have been attributed to him. For instance, it is popularly believed that Einstein was left-handed, had extreme difficulties in school, and possessed other strange quirks. Almost all of these oddities have been determined to be false.
Ultimately, it should be noted that Albert Einstein had a normal childhood typical of his socio-economic class. He played music, built models, built mechanical devices and once again, despite common misconceptions to the contrary, showed a strong aptitude for mathematics. From a very early age Einstein studied books on science, math and philosophical books including the Critique of Pure Reason and Euclid’s Elements. As a student Einstein was, shockingly, a bit of a rebel. He was not a, “spraying graffiti on park monuments” or “slashing teachers’ tires” kind of a rebel. (Though that would certainly have been awesome, if they did in fact have cars in 19th century Germany. Perhaps ‘smashing coach wheels’ would be a more accurate depiction? ) Einstein was more of a nerd-rebel; most of his acts of rebellion dealt with his aversion to the methods of academic institutions. He strongly opposed the institutionalized way education was conducted. He frequently rebelled against authority figures in the school system and strongly rejected the teaching methods. In fact, he once wrote that the “true spirit of learning and creative thought were lost in strict role learning.” (The student in me has to add that this is a very brilliant sentiment. The necessity of rote memorization to pass a class has been the bane of my educational existence!)
In 1901, after living for an extended period of time in Aarau, Switzerland, Einstein acquired his diploma and official Swiss citizenship. Though he studied to be a teacher, he was unable to find a teaching position and instead took a position as a technical assistant in the Swiss Patent Office. He spent a few good years in the patent office and managed to obtain his Doctorate degree. During this time he published some of his most remarkable and prolific works including his most famous paper: the Special Theory of Relativity. A paper that yielded previously unknown mysteries of the Universe and what is arguably the most famous equation in the world: e=mc2. It was a formula that revealed, if I understand it correctly, that the speed of light is a constant against which even time and space lose their absolute meaning. (Though as far as I can tell an existentialist could have told you that much.) In 1909 Einstein became Professor Extraordinary (quite a flashy title) at Zurich, and in 1911 he became a Professor of Theoretical Physics at Prague. He returned to Zurich later that year to fulfill a similar post. In 1914 he not only received a job as the Director of the Kaiser Wilhelm Physical Institute and Professor at the University of Berlin, he also took back his German citizenship. In 1921 he was awarded the Nobel Prize in Physics, an award that would make him an international star and a household name around the world. Einstein stayed in Berlin until 1933 when the rumblings of World War 2 caused him to revoke his German citizenship once again and immigrate to the United States. He became a professor of Theoretical Physics at Princeton and in 1940 he acquired US citizenship. (That’s citizenship from three different countries, for those of you counting at home.)
Despite all of the wonderful physic achievements Einstein acquired during this time, I believe his most remarkable and unusual achievement came after World War 2 when he became a leading figure in the World Government Movement that sought to rebuild the damage the war had caused to the European Continent. He was offered the Presidency of the State of Israel, an unimaginable title that he unfortunately declined. (I say “unfortunately” because the idea of a German leading the state of Israel is, well, the irony is simply too much.)
Einstein’s contributions to today’s world include, but most certainly are not limited to, the development of the television, remote control devices, lasers (what?! awesome!) and DVD-Players. He was honored as TIME magazine’s “Person of the Century” in 1999, which was certainly no small feat considering the people who lived during the time. He was a brilliant, aesthetically eccentric and monumentally, influential physicist who changed the face of science as we know it. His unquestionable skills and world-renowned influence are only a few of the reasons why Montblanc has decided to add the genius to their limited edition Great Characters Series. An Acknowledgement to the great strides made by truly remarkable human beings, this series produces artwork masterpieces worthy of their patrons. 2013’s champion is the Albert Einstein Limited Edition pen limited of 99 pieces and the Albert Einstein Limited Edition of 3000 pieces.
The 99 Limited Edition style is named after the atomic number for Einsteinium, the chemical element named after him. Its body is crafted from solid white gold and is covered in a delicately designed skeleton net. The image has a filigree overlay meant to represent the space-time curve. It relates to how Einstein was, in his research, able to uncover that the universe and time can be stretched, pulled, and warped by matter. Many of Einstein’s most famous formulas are engraved upon the pen’s barrel and cone. The nib is emblazoned with an engraving of Einstein’s chemical element. The clip is bejeweled with a sapphire stone approximately 1.3K while the star-shaped Montblanc emblem crowning the cap is made of a pure, luminous moonstone. The 3000 piece edition is named after the measurement of the speed of light: ~300,000,000 m/s. (This is an approximation, since in 1975 the speed of light was calculated to be 299,792,458 m/s. I suppose the former just looks neater.) Much like the 99 Limited Edition, the pen’s platinum-plated lines break up the body’s dark blue lacquering to once again evoke an image of the space-time curve.
Also checkout the ink bottle for this amazing pen
Albert Einstein’s breakthroughs in physics have helped redefine how people observe and measure the universe. He revealed profound truths that gave the scientific community a way of unlocking previously unknown mysteries of the universe. Honored in life and immortalized in death, Albert Einstein irrevocably, and unquestionably, changed humanity as we know it.