Main Points:
- The lungs are the primary target organ for these airborne mountaintop mining particulates.
- The results of this study show that chronic exposure (3 months) to 1 microgram/milliliter (µm/mL) of mountain top removal mining air on rat lung cells increased cell formation, cell clumps, and cell clump migration throughout their bodies.
- This study shows that air particulate matter from mountaintop removal communities promotes tumor growth, with a synergistic effect from the presence of molybdenum.
Overview Summary
- Study Background:
- Silica and molybdenum are main inorganic chemical constituents of PM
- Air particulate matter samples were taken within 1 mile of mountaintop removal sites. These samples were used to expose rat bronchial (lung) cells to similar human environmental exposure amounts.
- The rat lung exposure amount was 0.1µg/cm2 for 3 months which would be the equivalent of a human consistently breathing 5µ/m3 of mountain top mining particulate matter over 8.5 years.
- Findings:
- Mountain top removal particulate matter promoted tumor growth in the exposed rat lung cells.
- Cell creation, growth, and migration were expressed among the exposed cells.
- This study shows that cells are more likely to become cancerous in mining communities near mountain top removal than non-strip mining communities.
- Conclusions:
- A growing body of evidence links living in proximity to MTM activities to greater risk of serious health consequences, including significantly higher reports of cancer.
- The present study demonstrated that chronic exposure to PMMTM induced neoplastic transformation of human bronchial epithelial cells with cancer-like properties.
- Implications:
- As more than 60,000 cancer cases have been estimated to correlate with MTM activities in West Virginia, this finding on the cancer-promoting effect of PMMTM and related epidemiological data are crucial to raise public health awareness to reduce cancer risk.
- This study also suggested that molybdenum could be one of the key inorganic elements responsible for the cancer-promoting effect of PMMTM.
- Policy Considerations:
- Our data indicate the cell-transforming and tumor-promoting effects of PMMTM; thus, supporting the prudent adoption of prevention strategies and implementation of exposure control for PMMTM.
- Funded by and/or conducted by:
- This study was funded by the National Institute of General Medical Sciences and National Institutes of Health.
- Lab analysis was conducted at the West Virginia University Flow Cytometry Core Facility which is funded by the Mary Babb Randolph Cancer Center and National Institutes of Health.
Citation: Luanpitpong, Sudjit, et al. “Appalachian Mountaintop Mining Particulate Matter Induces Neoplastic Transformation Of Human Bronchial Epithelial Cells And Promotes Tumor Formation.” (2014): BASE. Web. 14 Feb. 2017.
Appalachian Mountaintop Mining Particulate Matter Induces