About you
As a Plant or Production Manager, you are responsible for maximising the safety of your people, the quality of your products, the service to your customers, the productivity of your process and the cost efficiency of your whole operation. At the front line of the value-adding activities of your business, you play a huge role in delivering value for customers while minimising waste in all its forms.
Your goals
The health, safety & wellbeing of your employees and, perhaps, your environmental impact, are likely to be among the first goals you will consider. For most organisations that we work with, these objectives represent core values that cannot be compromised in the pursuit of improvement in other areas. We consider this an essential foundation of operating an ethical and sustainable manufacturing operation.
Plant and Production managers play a critical role in contributing to the overall customer experience. Firstly, product quality is fundamental. Customer complaints will often, but not always, be the result of deviations in the material inputs or the manufacturing process. As such, managing material and process risks and encouraging stabilisation of the process should be a key objective for any plant or production manager.
While product quality forms an essential component of the overall customer experience, production also have a vital role to play in minimising order-to-ship lead times (particularly for make-to-order products) and improving On-Time-In-Full (OTIF) service levels. Achieving this requires aligned demand & capacity management, responsive and reliable suppliers and a stable production process. Plants that reduce their order-to-ship lead time, while improving both quality and service, provide their commercial teams with an enhanced competitive advantage that can be used to win significant new business.
Finally, the costs of both material inputs and conversion erode product margin and business profitability. Plant and Production Managers play a key role in minimising yield losses (reducing scrap) as well as driving out waste to utilise assets, manpower, utilities and energy far more efficiently. By producing at minimal waste and low operating costs, the business can benefit from some combination of increased profitability, customer retention and generation of new business.
Common Challenges
While Plant and Production Managers are typically faced with a great number of day-to-day challenges, the following represents some of the bigger, more strategic concerns that we frequently observe:
- Weak collective understanding of Lean Thinking principles, processes and tools. While most organisations have had some exposure to lean tools or concepts, few plants that we see have a leadership team that universally understands the principles of Lean deeply enough that they are able to continuously guide the organisation in a single unifying direction for improvement. Engaging and inspiring your leaders to embrace positive change through lean thinking is often the first hurdle that must be overcome.
- No clear vision or roadmap for improvement. A key step in any lean transformation is to deeply map the current process and identify the significant issues, wastes and constraints that are inhibiting flow. We have found that even this analysis has been completed, it is often poorly prepared and missing the key data and information necessary for a holistic understanding and diagnosis of the problems. This lack of understanding of the real issues often leads to weak improvement roadmaps that fail to address the most pressing areas of concern.
- Poor execution of the roadmap. Even when an effective value stream vision and plan have been developed, the results are often not delivered due to poor execution of the roadmap. This can be due to weak buy-in, insufficient accountability and governance, or significant capability gaps in key Lean and Project Management tools.
- Failure to establish an effective Lean Management System. On top of specific projects that form the high-level roadmap, organisations that truly embrace lean thinking must engage their entire workforce in driving improvement. This involves establishing a Lean Management System that continuously reinforces accountability for standardised work, visual management, 5S and problem solving. Introducing tools and processes that sustain key lean leadership behaviours is critical to any successful transformation.
- Failing to proactively anticipate and eliminate quality risk. Many organisations rely purely on reactive problem solving to drive improvement, for example, following a major complaint investigation. Organisation’s with the best quality performance have a clear process for systematically identifying process quality risk and accountable teams that drive this risk down every day. The result is a significant and sustained reduction in both internal and external quality problems.
- Weak problem solving and issue resolution capability One key capability that is frequently overlooked is practical tools for effective problem solving of complex issues. While the simple 5-Why’s technique is a useful place to start for many problems, leaders in production, engineering and quality are typically expected to provide more advance problem solving support for complex issues. Developing this capability among your staff is a critical success factor for any successful lean transformation.
Get in touch
If you can identify with any of the issues above, why not contact us today to learn more about how Pico can help you to grow your business by enhancing the customer experience, while relentlessly driving out waste.