There has been a fascinating linguistic development in Sweden, and one that poses a question for a possible future change in English.
Gender politics is a hot topic in the Scandinavian country, and it recently led to the publication of what was described as the country’s first gender neutral children’s book, Kivi och Monsterhund. The gender neutrality came from the use of a new personal pronoun instead of ‘han’ for he or ‘hon’ for she. The word that was used was ‘hen’.
Hen has now taken a step towards official recognition by being included in the country’s National Encyclopedia. So the question for English is: do we need a new word to be created to exist alongside ‘he’ and ‘she’ which allows things to be described without a potential user’s gender?
English already has alternatives. ‘They’ is often used when a person’s sex is unknown. ‘It’ is another possibility, albeit one that seems to depersonalise people. But I think in English, any change would purely be one of practicality, rather than linguistic politics, which seems to be the driving force behind the Swedish decision.
Which is not to say that English does not have inherent sexism built in, it is just that I don’t think this is it. The English language is full of what can be called unequal lexical pairs, where the male and female equivalents of a word carry more differences in meaning than just the gender difference. Think about master and mistress. On the surface, they should be equivalent titles, like Mr and Mrs. But a Master of Arts has expertise in an academic subject; a Mistress of Arts sounds like the kind of person who would charge a premium for personal services. And in that vein, a man who is active between the sheets is a gigolo, praised for his virility. Language unkindly has pejorative words like slut for the female equivalent – language summing up the prevailing sexist attitudes of centuries gone by.
So does language reflect thought or condition it? I think it is the former, though I have long been fascinated by the Sapir- Whorf hypothesis, which posits that the language you speak affects how you think, so if certain words are not present, your world view is affected. This is a complex subject, not easily dismissed, but the absence of a word does not stop a person having a thought. Instead, we should see language as a reflection of where it has come from and watch how changes in society then permeate through to everyday speech.
Which brings us back to Sweden, and a pronoun whose creation seems very clearly to represent a mood in the country, as well as being a great catalyst for a conversation about political correctness gone too far. Is this a change that is needed in English? Probably not. Could it be brought in even if it was needed? Definitely not.
There is one context in which it would be useful, however. The Wordability family will expand later this year with a second child. I currently refer to the growing baby as ‘he or she’, as I don’t want to commit myself, and as pointed out above, ‘it’ just seems too clinical and object like.
Maybe I should just adopt ‘hen’ for the foreseeable future.
4 thoughts on “Sweden Eliminates Men and Women”
Linda
I was so excited to hear the Swedes have come up with a new word. We badly need one in the English language. In our attempt to be gender-neutral we use ‘they’ or ‘their’, which is VERY confusing when talking about individuals. It also makes a grammatical mess of sentences, when the subject is plural one minute and single he next. The media abounds with examples. Pay attention to quotes in the news. Another example is: I don’t know how many people have read the progress notes about me, I don’t even know what is in there. You didn’t speak to your best friend for a month after they read your journal (From YOU AND I by Elaine Popovich. This series of statements seems to have gone through some transformations over the years, and some of the worst grammatical mistakes have been corrected.) So how many people read the journal???? ‘Your best friend’ sounds like one. ‘after they read your journal’ sounds like more than one person read the journal. We often use ‘they or their’ to be gender-neutral. WIthout a specific pronoun for this purpose, what we’re left with is unclear language.
I have no interest in being in a genderless society, or reading my kids stories where the characters are genderless, but for grammatical reasons, in order to keep our lanaguage clear and precise, I can’t wait until we have an English word that can be used for ‘he’ or ‘she’ – singular, so that we can get away from this clumsy use of ‘they’ and ‘their’.
Pingback: Nerds Fight Back in Sweden | Wordability
Pingback: A Year Full of Bluster | Wordability
Pingback: A Load of Old W***? | Wordability