CodePlexProject Hosting for Open Source Software
Hi
I'm comparing my MathNet eigen-decomposition with the one from Matlab. The eigen values are identical but the eigenvectors do not correlate..and it doesn't look like a scaling issue to me.
CC = new DenseMatrix(3, 3);
CC[0, 0] = new Complex32( 2.8123f, 0.3302f);
CC[0, 1] = new Complex32( 4.9281f, 0.1065f);
CC[0, 2] = new Complex32( 2.9926f, 0.1885f);
CC[1, 0] = new Complex32(-0.7638f, 0.4657f);
CC[1, 1] = new Complex32( 1.2616f, 0.4053f);
CC[1, 2] = new Complex32(-1.3960f, 0.2950f);
CC[2, 0] = new Complex32( 3.3723f, 0.1272f);
CC[2, 1] = new Complex32( 6.3473f, 0.1351f);
CC[2, 2] = new Complex32( 5.7357f, 0.3368f);
eigVR = new UserEvd(CC);
Yields:
[MathNet.Numerics.LinearAlgebra.Complex32.DenseMatrix] {
(-0.2683224, -0.3892781), (0.4026686, 0.7535514), (0.8103176, -0.3028587),
(0.3325276, 0.04118589), (0.05912521, -0.0987411), (-1.135981, -0.2766953),
(-0.5707567, -0.5817487), (-0.3471378, -0.3766167), (1.872847, -0.1478064)}
MatrixD {
(5.573158, 2.325578),(0, 0),(0, 0)
(0, 0),(0.7181261, 0.09491814),(0, 0)
(0, 0),(0, 0),(3.518316, -1.348196)}
Whereas Matlab produces:
[V,D]=eig(C) % using the same matrix values as above
>> [V,D]=eig(C)V = 0.4658 + 0.0811i 0.8520 0.3500 - 0.1002i
-0.2623 + 0.2085i -0.0591 - 0.0984i -0.4675 - 0.1537i
0.8150 -0.4944 + 0.1283i 0.7907 D = 5.5731 + 2.3257i 0 0
0 0.7181 + 0.0949i 0
0 0 3.5183 - 1.3483i
Did I do something wrong?
Thx
>Did I do something wrong?
No, there is a bug in our Complex/Complex EVD classes.
>eigVR = new UserEvd(CC);
In general, you should use:
eigVr = CC.Evd();
or
eigVr = new DenseEvd(CC);
instead when working with dense matrices. CC.Evd() will use the DenseEvd class which might be a little quicker (at least for larger matrices).
OK, thanks!
How do I get to know when this has been fixed?
If you follow this issue, you'll get notified when it has been fixed.
Hi Cuda,
Maybe your eigen solver does compute the correct eigen vector. I've realized that eigen vectors are not unique up to some constant k.
I tried to divide Matlabs principal eigen vector with Math.Net's principal eigen vector:
>> k = EigV_Matlab./EigV_MathNet
k =
-0.70036 + 0.71383i
-0.7004 + 0.71377i
-0.70035 + 0.71383i
Cheers
Are you sure you want to delete this post? You will not be able to recover it later.
Are you sure you want to delete this thread? You will not be able to recover it later.