Original article by Megan Hernbroth published in Business Insider
- BrainCheck is a startup that can assess and manage cognitive impairment virtually.
- The Texas-based startup announced it had raised $10 million in Series B funding Wednesday.
- The cofounder and CEO Yael Katz said the company wants to proactively manage conditions.
When Yael Katz learned that many instances of worsening dementia were preventable through early detection and long-term management, she knew she had to leave academia to have a bigger impact.
Katz, a former neuroscience researcher at Northwestern and Princeton universities, started BrainCheck in 2015 with the neuroscientist Dr. David Eagleman. On Wednesday, the Texas-based company announced it had raised $10 million in Series B funding. Next Coast Ventures, a staple of Austin’s venture-capital community, led the round with S3 Ventures, which also included participation from True Wealth Ventures, Tensility Ventures, Nueterra Capital, and two strategic investors in UPMC Enterprises and SelectQuote. BrainCheck has raised $20 million to date.
BrainCheck makes software for primary-care physicians and nonmedical professionals like insurance agents to conduct cognitive assessments for patients in person or virtually. Once the assessment is complete, BrainCheck shares a personalized management plan with the doctor to help slow cognitive decline.
BrainCheck takes commonly used cognitive assessments and makes them available online. Its management plans are based on research from neurologists. These tools are often out of reach for primary-care doctors who see patients daily, Katz said.
Anyone can administer the test by sending the patient a link to the test they need and reviewing their score. The score is based on a database of healthy individuals taking the same tests to determine when someone has below-average cognitive ability.
BrainCheck has conducted or funded more than a dozen studies showing that its approach is effective in preventing the decline of cognitive capabilities in its patients, according to a company representative. It has also been subject to independent study determining its effectiveness, with one 2019 JMIR Aging study concluding that its software “provides a sensitive and specific metric for age-related cognitive impairment in older adults, with the advantages of a mobile, digital, and easy-to-use test.”
Katz told Insider that the transition to virtual care during the COVID-19 pandemic readied the industry for a company like BrainCheck. During the pandemic, many Medicare patients missed the annual wellness checks in which cognitive conditions are typically identified, while doctors treating Medicare patients, were exposed to virtual-care options they might not have been aware of before.
BrainCheck provided its investor presentation to Insider for this story. The presentation was lightly edited to remove sensitive financial information and details about future products before Insider’s review.
Here is the 12-slide presentation Katz used to raise $20 million for BrainCheck to make cognitive assessments more widely available.
BrainCheck is a startup that helps doctors conduct cognitive assessments virtually or in person as well as develop and maintain management plans for patients with cognitive conditions.
BrainCheck
BrainCheck makes software that it sells to doctors that can help identify cognitive conditions using a set of assessments that are typically done with pen and paper in a doctor’s office. Doctors can use the software during a visit to conduct the assessment live, or they can text a link to patients to complete it virtually.
BrainCheck
BrainCheck is an FDA Class II software as a medical device, Katz said. Any patient or doctor can use its software assessments on any iPhone, iPad, or desktop computer.
BrainCheck
BrainCheck sells software directly to doctors, who have access to a personalized management plan for each patient based on the assessment results. With the funding, BrainCheck plans to also build a patient portal where patients also have access to the management plan and see their progress.
BrainCheck
BrainCheck declined to name the health systems with which it has worked, but Katz said that it works with Medicare and many private insurance plans to cover roughly 90% of costs.
BrainCheck
As part of the Series B funding round, the University of Pittsburgh Medical Center signed on as a strategic investor and is piloting an early dementia-detection trial with BrainCheck.
BrainCheck
BrainCheck is also an active research partner with several organizations and academic centers, Katz said. Part of her goal with the company is better funding research that can help inform doctors treating patients. The company did not disclose its specific partners, but did name partnership areas in the presentation.
BrainCheck
The patient portal BrainCheck is working on will be called BrainCheck DTx and will include tasks like cognitive puzzles and brain games patients can complete to better manage cognitive conditions within the app itself. Katz said this can help patients stick to the management plan better and improve their experiences.
BrainCheck
In addition to Katz and Eagleman, BrainCheck has hired several medical executives and technologists to lead its team. With the funding, Katz said the company will hire more sales and marketing professionals to increase its ability to sell to large health systems and insurance companies.
BrainCheck
“We have to be proactive about cognitive health and help provide access to care wherever they are,” Katz said. “Humanity realized there is something we can do about dementia.”
BrainCheck