Wouldn’t it be great if you could just collect dividends without suffering the ups and downs of the company? There’s a dividend capture strategy that implements exactly this. The basis of this strategy is to hold a stock just long enough to receive the dividend. Fundamentally, it is an easy strategy to apply but it can be a challenge to successfully execute.
The Basics
It is important to understand a few basic concepts before trying to implement a dividend capture strategy. Firstly, dividends are a portion of a companies profits that are paid regularly to shareholders. They are usually paid quarterly but they can also be paid a monthly basis. Many investors rely on dividends as a source of income due to low volatility, low to moderate risk and competitive yields. This dividend capture strategy can be especially useful when a less attractive company pays a very attractive dividend. You can capture the generous dividend without assuming the risk of holding the company over a long period of time.
Dividend Dates
It is important to understand dividend dates to successfully implement this strategy. The important dates to understand are the declaration date, ex-dividend date, record date and the pay date.
Declaration date: This is the date in which the board of directors declares when the dividend will be paid and how much the dividend will be.
Ex-dividend date: This is the date in which investors must by the stock before to receive the dividend. This is also the date in which the stock is supposed to be reduced by the dividend amount.
Record date: This is the date in which a company reviews it records to determine which shareholders are eligible to receive the dividend.
Pay date: This is the date in which shareholders will actually receive the dividend.
Time To Buy
Once you understand all four dates it’s time to implement the dividend capture strategy. Simply, buy a stock before the ex-dividend date and either sell on or sometime after that date. After you have owned the stock on the ex-dividend date you no longer need to own the shares to receive the dividend.
How To Make Money
If the stock is going to be reduced by the amount of the dividend you won’t make any money right? Right, but this isn’t always the case. In a perfect world this would be the case and you would break even every time. Fortunately for the dividend capture strategy we don’t live in a perfect world. Sometimes the stock will increase on the ex-dividend date, or a few days after, netting you capital gains and your dividend. By the same token the stock may drop past what the expected dividend is netting you a loss that even the dividend won’t make up for.
Loss: Let’s say Company 1 is trading at $30 per share and declares a $0.50 dividend. You buy the stock before the ex-dividend date and on the ex-date it drops down to $29 per share. This would result in a loss of $0.50 per share.
Break even: With the same scenario let’s say Company 1 drops to $29.50 on the ex-date. This would result in a break even situation, no gain or loss.
Gain: Now if Company 1 stays at $30 per share on the ex-date this would result in a gain of $0.50 per share.
The dividend capture situation aims to take advantage of the third scenario. Since it could go either way there is a certain amount of risk involved with this strategy.
Things To Consider
Before going out and trying to implement this strategy there are some things you should consider first.
Taxes: You won’t have the tax advantage for holding the stock long-term. You have to hold a qualified stock for at least 60 out of the 121 day period to receive the tax benefits. You’ll have to pay ordinary income tax on all the gains you receive from this method. Be sure to read this article to better understand taxes on dividends.
Brokerage fees: If you have a broker that charges per trade you’ll need to factor in the price of two trades into this. If your broker charges $5 per trade you’ll need to make an extra $10 to cover your buying and selling fees.
Market factors: There are an infinite number of factors that could also affect the stocks price come the ex-dividend date. Pay attention to the market for at least a few days prior to purchasing so you have an understanding of the recent trends.
Take A Shot
A big advantage to this strategy is that you could implement it just about every day if you wanted to. There are ex-dates just about everyday so you could theoretically do this full time. It’s also a nice way to stay involved with the markets when prices are so high and it’s tough to initiate a long term position. If you find yourself stuck, seeking extra income or simply bored try out this dividend capture strategy!
How often do you implement a dividend capture strategy?
Save
Save
Save
August 5, 2016 at 7:46 pm
An interesting post, I never thought of dividend before. xx
August 5, 2016 at 8:36 pm
Thanks Anna. Maybe it’ll give you something new to try! Let me know how it works out for ya!
August 6, 2016 at 4:34 pm
Interesting approach, and I kind of contemplated something similar myself. Have you tried this strategy out extensively yourself or backtested it?
August 6, 2016 at 4:40 pm
I’ve tried it a few times. It can go either way. I’m working on building a reserve cash supply in my brokerage account that I can use for things such as this and shorter trades.
August 9, 2016 at 11:37 am
I am not a stock owner. But this seems like a great strategy if I were, thanks! Useful post.
August 9, 2016 at 11:42 am
You’re welcome, if you ever want to start I’d be happy to give you some advice!
August 13, 2016 at 5:53 pm
You really need to get in a couple days before the declaration date to work
August 14, 2016 at 3:35 pm
Very valid point!
August 26, 2016 at 2:03 pm
In practice, however, this does not always happen and is the reason why investors utilize the dividend capture strategy. Essentially, the dividend capture strategy aims to profit from the fact that stocks do not always trade in strictly logical or formulaic ways around the dividend dates.
September 1, 2016 at 2:41 pm
Exactly, well said!