Last year, the marketing people at Le Creuset were looking for a new way to generate buzz. The French cookware brand didn’t have a huge media budget, but it did have an 87-year heritage—and that gave them an idea. “Our factory in France maintained a fleet of Citroën Truckettes back in the 1950s and ’60s,” says marketing communications director Will Copenhaver. “We thought that having one appearing around the country would be a conversation starter.” After a fair amount of searching, the company finally located a run-down 1967 Citroën in a New Jersey junkyard. “We worked with a vintage auto restorer and brought it back to life,” Copenhaver says. Today, the truck makes the rounds of store openings and culinary events, putting a unique and memorable face on those fancy pots and pans.
Le Creuset is only the latest brand to awaken to the potential of one of marketing’s oldest, oddest and most proven marketing vehicles: the literal marketing vehicle. National brands such as Peeps candy and local companies including New York’s Bowlmor Lanes practice street-level marketing in its purest form by using quirky, customized cars to distribute product samples, spark consumer conversation or simply imbue their brands with an inimitable quotient of cool. The idea is not cheap—a ground-up concept vehicle can run as much as $600,000. Nor is it easy. The original Zippomobile was stolen in the 1960s and still has not turned up. But it does turn heads. “These vehicles get impression 24/7—on the road, in a hotel parking lot at 2 in the morning, all the time,” says Dorian Duke, founder and owner of Prototype Source, which created the Kissmobile for Hershey’s and Oscar Meyer’s Wienermobile, among others.
Ironically, the rise of digital marketing may have made these promotional automobiles—an analog idea if there ever was one—more effective, not less. “These vehicles get attention and break through the noise, but that’s just the beginning—the second part is the digital brand activation,” explains John Hendricks of digital branding agency BoomBox. In fact, even the oldest such vehicle on the road—Oscar Meyer’s Wienermobile, rolling since 1936 and now boasting a fleet of six—is, much like food trucks that are so in vogue, fully Web-integrated, with Facebook fan pages, geolocation technology and drivers who tweet.
Adweek pulled over six of the coolest marketing rides on the road, wanting to know whether they were worth the gas money. Here’s what they told us.
Le Creuset Truckette (2011)
“From food festivals to store openings, the Truckette’s been a great icon for us. It draws attention wherever it goes. I would argue that physical marketing vehicles are especially relevant in the digital age. People love talking about it on social media platforms. We’ve even had people jumping on Facebook to ask if the Truckette will ever come to Hong Kong.”
—Will Copenhaver, marketing communications director, Le Creuset
Zippomobile (1947)
“It’s a monster that’s 16 feet long, 12 feet high and 2½ tons—and it gets attention better than any marketing tool we have. People still need to be awed by physical things, and this makes you stop and appreciate the quirkiness of the brand. We take it to Nascar races, car shows, motorcycle events. We’ll take your picture with it, and you can go and download it online. Everyone wants to be seen with the car, just to prove that it’s real.”
—Brent Tyler, global brand manager, Zippo
Peepster (2003)
“We visit high-traffic locations and special events. The reaction is spectacular. We’ve had fans, even the police and firefighters follow us honking their horns until we pull over for a photograph—and some Peeps. It’s the perfect way to bring social and digital media together. A Peepster sighting is worthy of a tweet, a wall post or a blog mention, and we appreciate every one of them.”
—Brian Bachrach, senior brand manager, Peeps
Bowlmor’s ’57 Cadillac (1997)
“Our CEO Tom Shannon is a classic car collector, so this was his idea. We park it out in front but also use it for events like the Pride Parade. Our brand ambassadors will pass our fliers from the back of it too. Bowlmor is New York’s original bowling alley [since 1938], so the car is completely on-brand. It matches the product in a unique way we couldn’t accomplish digitally, though I have noticed the car ending up on everything from car blogs to Flickr.”
—Colie Edison, director of brand strategy, Bowlmor
HSBC Bank Cab (2003)
“I’ll be sitting at an intersection, and there will be people on all four corners pointing at the car because the old Checker cabs have vanished from New York. And some people can’t get over the fact that it’s free. I’ll take anybody anywhere in Manhattan if they show me their HSBC bank card or deposit slip. But I’ll take you if you can tell me at least where your branch is. In my mind, everybody’s a potential customer.”
—Johnnie Morello, driver
Wienermobile (1936)
“We have six Wienermobiles, each piloted by two ‘hot doggers’ who are trained brand ambassadors. They blog and they tweet and provide content for our Facebook page. This summer, they’ll have tablets, and they’ll take a picture of you with the Wienermobile and then send you a digital postcard you can send to family and friends. Our marketing plans involve the Wienermobile every year.”
—Ed Roland, senior marketing manager, Oscar Mayer
Illustrations: Amanda Lanzone
