Tensions within the world's most powerful media family were dramatically laid bare on Thursday when Elisabeth Murdoch set out her own vision of media leadership, emphasising humanity over profit and criticising her father's News Corporation for operating with an absence of values.
Giving the keynote MacTaggart address at the MediaGuardian Edinburgh International Television Festival, Rupert Murdoch's second daughter also explicitly contradicted her brother James, chose to praise the BBC, and argued that the Olympics experience demonstrates that television is a force for storytelling rather than a route to political power.
Speaking in public for the first time about the phone-hacking affair, which prompted her to fall out with her brother a year ago, Elisabeth Murdoch said that News Corp had to ask "significant and difficult questions about how some behaviours fell so far short of its values" in the wake of what happened.
She said the lesson from the affair was that any organisation needed to "discuss, affirm and institutionalise a rigorous set of values based on an explicit statement of purpose" – in contrast to News Corp's traditional mode of governance based on executives second-guessing what Rupert would do.
The cri de coeur from the 44-year-old, who runs Shine Television, the News Corp-owned maker of programmes such as Masterchef and Merlin, will be interpreted as a bid for power at her father's company – although her friends insisted she had no desire to lead the company her father built, which spans from Fox News in the US to the Sun in Britain.
Elisabeth Murdoch took aim at her younger brother James in an extended passage that referred to his own controversial MacTaggart lecture given three years ago.
That speech ended with James – weeks before the Sun switched to the Conservatives – observing that "the only reliable, durable and perpetual guarantor of independence is profit".
Elisabeth said that while loss-making media organisations had their independence "massively challenged", her brother's statement nevertheless "left something out".
Making little effort to soften the rift with her younger brother, she added: "Profit without purpose is a recipe for disaster."".
Her speech contained few references to her father's newspapers, but in a paragraph that referred to the Leveson inquiry, she said that "an unsettling dearth of integrity across so many of our institutions" meant that it was "very difficult to argue for the right outcome, which must be the fierce protection of a free press and light touch media regulation".
The 14-page, often-humourous speech was largely written by Murdoch herself – with much of the drafting work taking place during the wet jubilee bank holiday weekend – and with no input from other family members. Instead her husband, Matthew Freud, and a small team of advisers largely from within Shine helped check facts and polish the speech – the first time a woman has given the television industry's signature address since Janet Street-Porter in 1996.
It was hailed with warm applause and whistles from the audience, by contrast with the BBC-bashing speech of her brother James, three years ago at the same event, which was greeted coolly.
Elisabeth is the second oldest of Rupert Murdoch's six children, and the eldest by his second marriage to Anna. While brothers Lachlan and James have at various times worked directly for News Corp in the past decade, Elisabeth only rejoined her father's company last year after it bought Shine in a £290m deal just before the phone-hacking affair broke.
She had set up Shine in 2001 and banked about £150m from her father's company once the takeover was completed. But she turned down a seat on the News Corp board in the wake of the Milly Dowler hacking scandal.
There was conspicuous praise for the BBC, which frequently airs Shine programmes, in marked contrast to her father and brother. "Let me put it on the record that I am a current supporter of the BBC's universal licence fee," she said. She also praised outgoing director general Mark Thompson for working collaboratively across the television industry. Three years ago, James Murdoch accused the BBC of expansionist plans that had "a chilling effect" on the rest of the British media, but his sister's only critical observation about the national broadcaster was that the incoming director general had "to demonstrate how efficiently that funding is being spent on actual content on behalf of the licence fee payers".
There was little overt politicising in Elisabeth Murdoch's speech – another contrast with her brother's effort, which was widely seen as setting the template for Conservative media policy before the most recent general election.
But she repeatedly gestured towards liberal values with references to progressive political figures, including "one of my heroes" Vaclav Havel and Nelson Mandela whom she watched walk from prison "through my tears".
There was even praise for another former MacTaggart lecturer, the late Dennis Potter, who famously named the cancer that killed him "Rupert". She said she was "firmly with" the television playwright who said "the job of television is to make hearts pound" – a vision of the medium whose core purpose is "to form human connections" as opposed to a vehicle for the exercise of raw political power.
But she did defend her decision to sell Shine to her father's company – even if, as she acknowledged, it appeared to be a "no shit, Sherlock" decision – because News Corp was first and foremost a content company which had backed The Simpsons, Glee and the blockbuster films Titantic and Avatar directed by James Cameron.
While there was no shortage of criticism for her brother, there was praise for one Murdoch, her father.
"My dad had the vision, the will and the sense of purpose to challenge the old world order on behalf of the people," she said, before adding: "But back even then, I understood we were in pursuit of a greater good, a belief?)