A year from now, the American public will have the opportunity to elect a new president. A large fraction of citizens — usually between 40 and 50 percent — will decide not to vote. That alarms observers who consider low turnout a threat to the legitimacy of policymaking in democracies. Some of them worry that because voting and other forms of political participation are dropping, money matters more in politics. They argue that low turnout increases the effectiveness of campaign spending because it can be targeted at a smaller group of voters.
To counter the long-term decline in turnout, President Obama last March suggested mandatory voting, believing that “it would be transformative if everybody voted. That would counteract money more than anything.”
So would election outcomes look different if we had virtually universal turnout?
Answering that seemingly straightforward question is quite challenging. To assess how turnout changes the results, we would ideally observe an election twice, once under high and once under low turnout. Which is, of course, impossible.
In a recent study — “Does Compulsory Voting Increase Support for Leftist Policy?”— we try to find a way around this problem. We study federal referendums in Switzerland in the first half of the 20th century, examining referendum results in a treatment group and a comparable control group.
Our treatment group consists of districts in the canton of Vaud where citizens who did not vote had to pay a substantial fine that was collected by the local police. In the control group, voting was voluntary. In both groups citizens voted on the same policy proposals in federal referendums. So how did compulsory voting affect policy choices?
The fine boosted referendum turnout by 30 percentage points — giving Vaud participation rates of up to 90 percent, exceptionally high levels of civic engagement.
But what were the policy consequences? We find that higher turnout caused stronger support for leftist, redistributive policy, for example, bills that proposed stricter market regulation and expanded welfare programs.
The figure below shows the evolution of support for leftist policy proposals for districts in Vaud (red line) and districts in the control cantons (blue line). The gray shaded area represents the period in which Vaud practiced compulsory voting. We see little difference in support for leftist policy proposals between districts in Vaud and districts in the control cantons — at least, until Vaud introduces a fine for failing to vote in 1925.
Mandatory voting changed referendum outcomes. As soon as authorities in Vaud introduced compulsory voting, electoral support for leftist policy increased by about 8 to 15 percentage points when compared to the cantons where there was no fine. The green line in the figure equals the difference in support for leftist policies between districts in Vaud and districts in the control cantons, adjusted for their differences before the introduction of compulsory voting.
Taken together, these results suggest that compulsory voting not only increases turnout, but also mobilizes new voters whose preferences are sufficiently distinct to affect public policy.
These findings have implications for ongoing debates about the desirability of compulsory voting. If, for example, compulsory voting increased turnout but failed to change outcomes, low turnout would be more efficient as many citizens could save the costs of voting.
Our results suggest that compulsory voting not only increases turnout, but also shifts support toward particular policies. Therefore, the efficiency argument does not seem convincing in the case we examine.
Our results also answer a related question: Would mandatory voting lead to unstable political majorities, since it would bring to the polls a larger share of less-informed citizens who would vote more or less randomly on policies? After all, the opinions of those with less political knowledge could be more easily malleable.
That’s not what we find. In our context, compulsory voting causes a stable increase in support for leftist policies, a finding that is difficult to square with the random voting argument.
Michael Bechtel is SNSF professor of political science at the University of St. Gallen. Dominik Hangartner is associate professor at the London School of Economics and Political Science and the principal investigator of the Migration Policy Lab at the University of Zurich. Lukas Schmid is senior research associate in the Department of Economics at the University of St. Gallen.