Vampire squid have been lurking in the dark corners of the ocean for 30 million years, a new analysis of a long-lost fossil finds.
Modern-day vampire squid (Vampyroteuthis infernalis) can thrive in deep, oxygen-poor ocean water, unlike many other squid species that require shallower habitat along continental shelves.
Few fossil ancestors of today's vampire squid survive, though, so scientists aren't sure when these elusive cephalopods evolved the ability to live with little oxygen.
The new fossil analysis helps to fill a 120-million-year gap in vampire squid evolution, revealing that the ancestors of modern-day vampire squid already lived in the deep oceans during the Oligocene, 23 million to 34 million years ago.
These squid probably evolved adaptations to low-oxygen water during the Jurassic, said study co-author Martin Košťák, a paleontologist at Charles University in Prague.
"Life in stable low-oxygen levels brings evolutionary advantages — low predation pressure and less competition," Košťák wrote in an email to Live Science.
Related: Photos of the vampire squid from hell
A rediscovered fossil
Košťák and his colleagues found the long-lost fossil in the collections of the Hungarian Natural History Museum in 2019 while looking for fossils of cuttlefish ancestors. The fossil was originally discovered in 1942 by Hungarian paleontologist Miklós Kretzoi, who identified it as a squid dating back around 30 million years and named it Necroteuthis hungarica. Later researchers, though, argued that it was a cuttlefish ancestor.
In 1956, during the Hungarian Revolution, the museum was burned, and the fossil was thought to be destroyed. The rediscovery was a happy surprise.
"It was a great moment," Košťák said of the rediscovery, "to see something previously suggested to be definitely lost."
The fossil. (Košťák et al., Communications Biology, 2021)
Košťák and his colleagues studied the fossil with scanning electron microscopy and conducted a geochemical analysis. They first found that Kretzoi's initial identification was right: The fossil is from a squid, not a cuttlefish ancestor.
The animal's internal shell, or gladius, which forms the backbone of its body, was about 6 inches (15 centimeters) long, suggesting the squid grew to about 13.7 inches (35 cm) long with arms included. That's just a bit bigger than modern vampire squid, which reach about 11 inches (28 cm) in total body length.
The sediments surrounding the fossil showed no traces of microfossils often found on the seafloor, suggesting that the squid was not living in shallow waters. The researchers also analyzed levels of variations in carbon in the sediment and found that the sediment likely came from an anoxic, or low-oxygen, environment.
Those conditions are characteristic of the deep ocean floor. By looking at rock layers above where the fossil was deposited outside of what is today Budapest, the researchers were also able to show that the squid probably couldn't have survived in the shallower seas of the time.
The shallow-sea deposits showed very high levels of a particular plankton that blooms in low-salt, high-nutrient environments - conditions that modern-day vampire squid can't tolerate.
(Researchers from the Monterey Bay Research Institute discovered that while lurking in the deep sea, these squid don't behave like the nightmare predators their name suggests; rather, they wait in their dark habitats for crumbs of organic matter to flutter down. Then, they capture those bits with mucus-covered suckers, MBARI found.)
Adapting to the deep
The new research, published Thursday (Feb 18) in the journal Communications Biology, hints at how vampire squid ancestors learned to live where other squids couldn't.
Looking deeper in the fossil record, the oldest fossils from this group of squid are found in the Jurassic period, between 201 million and 174 million years ago, Košťák said, and they are typically found in anoxic sediments.
"The major differences is that these oxygen-depleted conditions were established in the shelf, [a] shallow water environment," he said. "This means that the ancestors were inhabitants of shallow-water environs, but they were already adapted to low-oxygen conditions."
There's a gap in the fossil record in the Lower Cretaceous, starting about 145 million years ago. The squid may have already shifted to the deeper ocean by this point, Košťák said, primed by their experiences with anoxic conditions in the Jurassic. This deep-water lifestyle might explain why the squid survived the crisis that killed the nonavian dinosaurs at the end of the Cretaceous period, he added.
The deep-living squid from 30 million years ago helps link recent history with the deep past, Košťák said. He and his colleagues are now attempting to make similar connections for cuttlefish, a group of cute, color-changing cephalopods whose origins are similarly murky.
Related Content:
Cuttlefish cuties: Photos of color-changing cephalopods
Photos: The vampire squid from hell
10 strange animals that washed ashore in 2020
This article was originally published by Live Science. Read the original article here.