Among the transformations that are confronting the power industry, few are as intriguing as the concept of “Blockchain”. Blockchain technology is a fairly recent innovation, known mostly in a financial context. It is a distributed, peer-to-peer approach to transactions designed by nature to be “unhackable.”. Blockchain is the foundational technology that enables the now famous bitcoin to function. But, the technology has much greater applications than just finance, with many experts believing it will be revolutionary for the energy sector.
This webcast will give an overview.
Learning Outcomes
- Discuss the fundamental components and operational processes of blockchain technology
- Evaluate the different ways and opportunities for blockchain technology to be applied in the energy industry
- Examine use cases of blockchain technology in the energy industry
- Review lessons learned with a blockchain technology pilot project, Brooklyn’s “Blockchain Microgrid” that enables residential energy trading
- Assess the role of blockchain technology in enabling a transactive, distributed energy resource grid
- Infer the adoption timetable and applications of blockchain technology by utilities and other industries in the entirety of the webinar and complete a post webinar assessment with a 70% or higher to receive continuing education.
Instructional Methods
PowerPoint presentations and instructor discussions will be used in this program
- Introductions
- Blockchain Technology Overview
- Core components
- Smart contracts
- Applications of core features
- Eliminating the need for the middle man?
- Current and Potential Industry Applications of Blockchain Technology
- Opportunities for Blockchain Technology in the Energy Industry
- Cryptocurrencies as a means for paying electricity bills
- Trading energy via smart contracts
- Transactive energy systems/peer to peer energy markets
- Distributed energy resources
- Improving existing systems
- Utility billing
- Demand response programs
- Wholesale energy trading
- Renewable energy credit (REC) certificates
- Electric vehicle charging applications
- Policy and Regulatory Regimes that would Enable Blockchain in the Energy Sector
- Use Cases of Blockchain Technology in the Energy Industry
- Case Study: Brooklyn’s Blockchain Microgrid
- Distributed grid solutions to bring together people, technology and energy
- Project overview
- Residential buying and selling of solar power on a blockchain platform
- System self sufficiency
- Challenges and lessons learned so far
- Imagining Blockchain’s Role in the Future of the Transactive Electric Grid
Ravi Pradhan, Portfolio Manager & Technology Strategy, Siemens
Ravi Pradhan is the Portfolio Manager & Technology Strategist for Siemens Digital Grid Division Software and Solutions in Minneapolis. In this position, he identifies and builds solutions to meet utility customer energy management and energy market needs using the deep portfolio of Siemens’ products. Mr. Pradhan has 20 years’ experience building and integrating control center systems, electricity market systems and other operational IT systems He is part of the global Siemens Digital Grid Software product house and is responsible for selecting and implementing the appropriate technologies for Siemens Digital Grid software solutions. He was previously the Vice President of Technology Strategy at Siemens, where he focused on architecting systems to accommodate the growing penetration of DERs in the grid, using technological and market mechanisms. Prior to that, he was a principal system architect for the California ISO (CAISO) Market Redesign and Technology Update (MRTU) project, which included a large IT integration component, along with market optimization software. Mr. Pradhan was also the executive technical lead for the PJM AC2 project that implemented a ground-breaking dual primary control center for managing the bulk of the northeast USA’s transmission grid. He has also been the lead on EMS projects in Mexico City; Johannesburg, South Africa, NSP in Minneapolis, and Hydro-Quebec in Montreal. He earned his B.S. in computer science from Purdue University in West Lafayette, Indiana.
Molly Suda, Partner, K&L Gates
M. She also focuses on the regulatory implications of integrating distributed energy resources and energy storage into wholesale energy and capacity markets, as well as issues associated with applications of blockchain technology in the energy industry. Ms. Suda has experience in defending against investigations of alleged violations of the laws and rules administered and enforced by FERC. She also advises clients on regulatory matters associated with the acquisition, sale, and development of generation and transmission assets.
Benjamin Tejblum, Associate, K&L Gates
Benjamin Tejblum is an associate in the K&L Gate’s Washington, D.C. office and focuses his practice on energy and infrastructure projects and transactions. His clients include electric utilities, electric transmission owners, independent power producers, power marketers, and public utility holding companies that are active in the electricity markets in the United States. Mr. Tejblum regularly represents clients before the Federal Energy Regulatory Commission (FERC) and has counseled clients on matters involving mergers and acquisitions, interconnection procedures and agreements, transmission rates and cost allocation, and market-based sales of energy. He also counsels energy start-up companies on a variety of regulatory matters.