Securing a Good Job Teaching English Is a Snap
By Lavinia Spalding
In the mid-'90s, South Korea became known as a country where one could earn a small fortune teaching English and it quickly became a hot spot for ESL instructors. In late 1997, however, the Asian economic crisis caused a mass exodus of Westerners, leaving Korea desperate for English education but unable to afford it. The country has not yet fully recovered, but it is well on its way. A renewed, almost palpable, optimism has spread through Korea
Hogwans, or private institutes, the easiest places to find work, have earned a reputation for being on the shady side. However, if you look carefully, plenty of reputable ones do exist and hiring packages have become increasingly attractive. A 1-year contract typically includes roundtrip airfare to Korea, a relatively competitive salary (the equivalent of $1,500-$1,700 per month for a 25- to 30-hour work week), housing, two weeks' paid vacation, and severance pay equal to one month's salary upon completion of your contract.
Do Your Homework
The basic rule for securing a good teaching position in Korea is to do your homework. Begin with Dave's ESL Café and ESL Worldwide, where you can sift through countless job advertisements. At, you'll find a wealth of general information on Korea. These sites also offer invaluable links to numerous other sites.
Pusanweb.com is a rich source of practical info. For answers to specific questions, join a discussion board on any Korea-related site.
Whatever you do, don't jump at the first job offer you receive. It's wise to search the Internet for blacklists (sometimes called greylists) that warn against schools best avoided. Before deciding to accept a job offer, try to contact another Westerner employed at the school so you can get the inside scoop.
Finally, remember that there's no lack of job opportunities-so if a school sounds even slightly sketchy, take a pass. Once you've signed a contract, getting out of it and changing jobs can be a colossal pain in the neck.
The Logistics
The traditional method of finding work in Korea is to secure employment in advance, but many teachers now head to Korea first and find a job after they arrive. A 3-month tourist visa is available to Americans and a 6-month visa to Canadians. Immigration officers who might wonder why you have no return ticket are usually mollified with an explanation that you plan to travel on to Japan via ferry.
Once in Korea, finding accommodations is painless and fairly cheap. Most people take a room at a yogwan (motel). These are ubiquitous and cost approximately $15-$30 a night. Finding temporary teaching work while searching for a permanent position isn't difficult. Short-term institute jobs abound and are most easily located on the Internet or by word of mouth.
The most significant benefit of arriving in Korea jobless is that you have the luxury of looking around for the position that offers the best teaching and living conditions. You'll be able to see the school and accommodations (insist on this), negotiate with the director, and consult other teachers at the school before signing a contract. Once you are hired, most institute directors will pay your way to Japan so you can obtain a work visa.
The Pay-Offs
While most people who move to Korea are enticed by the possibility of financial gain (saving $10,000 to $20,000 a year), that's certainly not the only reason to come here. Koreans are exceptionally warm and generous. Students are polite and respectful. And the culture is fascinating. One of the greatest rewards of life in Korea is the opportunity-around virtually every corner-to take classes and acquire knowledge. Koreans, particularly those living in smaller cities and towns outside of Seoul, welcome any chance to share their culture with foreigners. This means teachers can study everything from Korean language and cooking to meditation, traditional drumming, and martial arts at a truly minimal charge, in exchange for English lessons, or even for free.
Studying Tae Kwon Do or another martial art in Korea might cost you no more than $30 a month for intensive daily classes. Institutes and restaurants in most towns and cities offer lessons in Asian and international cooking. One such institute is La Cuisine in Seoul. On the other hand, convincing a Korean friend or student to teach you to prepare your favorite local dishes usually takes little more than a request. Volunteer groups across the country, offer Korean classes to foreigners at no charge. The Busan Buddhist mission busanmission@orgio.net offers free classes every other Sunday. Foreigners and Koreans are taught to make green tea, perform mask dances, meditate, fashion lotus lanterns, and learn a variety of other cultural crafts and traditions.
Korea, like all other developing countries, can of course be a challenging place to live from day to day: cities are crowded, traffic tends to be nightmarish, and, at first, Koreans might seem somewhat brusque or pushy. But once you've lived here a while and learned to navigate the cultural differences, the greatest challenge often lies in staying only a year or two. Countless expatriates fall so deeply in love with Korea that they wind up making it their permanent home.
LAVINIA SPALDING, writer, teacher, and traveler returned to America after five years in Korea.