It’s time to engage with virtual theatre organically and not use it just as a tool: Anuja Ghosalkar
The Bengaluru-based documentary theatre-maker features in chapter one of TheatreRoom’s talk series on ‘theatre and digitality’
“But we miss the actors and the panoply of a live performance on stage.” That’s how almost every conversation about virtual theatre seems to end. Indian theatre is at the cusp of a transition which may not wholly conform to the ‘community art form’ proposition, but is certainly more interdisciplinary in nature.
More experimental than traditional, more accessible (depending on Wi-Fi, of course!); and less formal, the digital expanse is a curious new world that’s best experienced organically. Sprawling across our phones and laptop screens, it’s probably safe to say that online theatre is no longer in its vulnerable infancy. Even institutional theatre now seems to be taking cues from it to serve the audience with a seamless experience, which before the social-distancing era was not much pondered upon.
Speaking at the first edition of TheatreRoom’s talk series on ‘theatre and digitality’, documentary theatre-maker and founder of Bengaluru-based collective Drama Queen Anuja Ghosalkar tells us why she feels that virtual theatre is not only about live Zooms; it’s a discourse that will continue only when we engage with it more and not assume it to be the interim. Excerpts:
Embracing the digital, but not giving in to triumphalism
Although the politics of digital is complicated, I consider this an opportune time for performance-makers. We’ll need to continue learning the language of the online world and strive to understand its aesthetics to get better at it. In India, however, the problem of unequal access to electricity and the internet also hinders the way art is consumed. Yet one has to persist, because we want to reach out to more audiences and communicate with them.
I am not cynical about the digital space, but I am also not giving in to triumphalism. There’s a fine balance between what we have lost to the pandemic and what lies ahead of us. While I know the pitfalls of the digital, I am also critical of how theatre was constructed in the past. If the virtual space is ‘elitist’, didn’t ‘gatekeeping’ exist earlier? But now can we move toward a theatre that is more equitable? Perhaps, yes.
Institutional theatre must respond to the changing times
The question of digitality is not limited to individuals or independent theatre-makers. The entire ecology needs to change, and that also includes institutional theatre. They need to re-examine how they do audience outreach, how they disseminate information as well as their ticketing structures. There have been instances in the recent past that point out that holding on to older ideas can impact the economics of theatre and limit our earnings. Without having to surrender to the digital impulses, institutional theatre can look beyond live-streaming of plays and accept the virtual medium in its organic form and not just as a tool.
The pandemic has changed the way we — as a community of actors, performance-makers and audience — perceive, comprehend and interpret theatre. The experience of the past two years has been traumatic for humankind. It has altered our body, mind and habits. In many ways, there’s probably no going back to the theatre again. Or perhaps, we’ll go back as different beings, to which the theatre must respond.
Pandemic projects and collaborations..
The ‘Lonely Hearts Club’ desire-erotica project started in a jiffy around the time the first lockdown was imposed in India last year. Buoyed by the number of contributions we received and the manner in which it was accepted by the audience, we are working on a part virtual and part in-person performance this year. This is likely to open in September.
In 2020, I also collaborated with my colleague, German dramaturg Kai Tuchmann for a virtual reality project that was showcased at the Serendipity Arts Virtual (SA Virtual) 2020. Currently, I am working on two essays, penning down the language used and the learning from these initiatives.
Besides that, I am working on another global project, called ‘White Money’. It’s again a research-based project that explores how money travels and my role as a cultural agent within this context. ‘White Money’ began in Germany by Flinn Works’ Sophia Stepf and Konradin Kunze, with artistes participating from Nigeria, Iran, Egypt, Tanzania and myself from India. If things go as planned, my performance will open in Germany this November.
Additionally, I worked on a performance called ‘1984 Back to No Future’, in association with Gob Squad. This was part of Drama Queen’s virtual residency with the British-German arts collective. The project investigates the collective popular imagination of the early 1980s. Music videos, photographs and newsreels were among the primary objects used during the workshop. It was the coming together of the complicated notions of science, nation, popular culture and what the future holds for us.
Interdisciplinarity in theatre is inevitable
We are in this moment where we have to work with other forms. Interdisciplinarity is simply unavoidable in terms of performance-making. We need to know camera angles; understand filming; and even have basic knowledge of coding and the different algorithms that are virtually carrying my performances to the audience.
For the various virtual projects that I have been involved in during the pandemic, I have worked with archivists, visual artists and academics. This allowed me to look at things from a completely different standpoint. Interdisciplinarity encourages one to relearn things and that I think is a great moment in itself.
Artiste and director Amitesh Grover’s cyber theatre production, called ‘The Last Poet’, which also opened during SA Virtual is a fantastic example of interdisciplinary work. It actually engages with the language of the online world. Similarly, artiste Mallika Taneja’s ‘Allegedly’ also takes into account the nuances and the form of the virtual space. These two projects find resonance with how I perceive the digital and the kind of work that I want to make.
To keep the discourse alive and take it to a larger audience, we also need journalists and academics to write on this moment of theatre and digitality. It’s necessary to document the historical track that we are trying to create and also critique our work. We all are in a collective conversation, trying to build a new ecology in a changed world. The sooner we acknowledge the learning and better we get at our practice.