Hardware requirements for the server on Linux
Ensure that the computer on which you are installing the BigFix Inventory meets the minimal CPU, and memory requirements for the server and database elements.
Virtualized environment
The ETL (extract, transform, and load) import heavily uses the DB2 database resources. BigFix Inventory and DB2 server can be installed on a virtualized environment. However, for large deployments that consist of 50 000 - 100 000 computers, it is recommended that dedicated hardware is used.
In a virtual environment for medium size deployments that consist of 10 000 - 50 000 computers, it is recommended that dedicated resources are considered for processor, memory, and virtual disk allocation. The virtual disk that is allocated for the VM should be dedicated RAID storage, with dedicated IO bandwidth for that VM.
Use DB2 server that is dedicated for BigFix Inventory and is not shared with BigFix or other applications. Fine-tuning based on the above mentioned recommendations might be required.
Processor and RAM
The values provided for BigFix were calculated with the assumption that the BigFix server, its database and Web Reports server are installed on a single server and that the BigFix server is dedicated to BigFix Inventory. If you share the BigFix server between other applications, refer to the BigFix documentation for information about hardware requirements: BigFix requirements.
The values provided for BigFix Inventory were calculated for the maximum of five concurrent application users.
- * For environments with more than 35 000 endpoints, scan groups are required. For more information, see Tuning performance.
- ** A distributed environment, where BigFix Inventory is separated from the database, is advisable.
- xmx The default settings for the Java heap size is not sufficient for medium and large environments. If your environment consists of more than 5000 endpoints, increase the memory available to Java client processes by increasing the Java heap size.
- Procedure
- 1. Go to the <INSTALL_DIR>/wlp/usr/servers/server1/ directory and edit the jvm.options file.
- 2. Set the maximum Java heap size (Xmx) as suggested in table above.
- 3. Restart BigFix Inventory server.
Disk space
BigFix Inventory
DB2 for BigFix Inventory
*The disk space requirements are calculated based on the average number of files that are discovered in your environment. The values that are provided in the formula assume that the average number of the discovered files is 800 per computer, which is represented by 1 and 1.2 MB. If, according to your estimates, the number of files is higher, increase this value adequately. If you already installed , you can use the Scanned File Data and Computers reports for your calculations. Note, that the required initial disk space (15 or 17 GB) is constant. The number of discovered files not only affects the size of the database,but also the server runtime memory requirements. For more information, see: Tuning performance in medium and large environments.* The formulas apply to typical environments that are configured to run weekly software scans, daily data imports, and whose endpoints have about 60 software installations each. The results also depend on the amount of data returned by the scans, which means that in some environments the required amount of disk space might be smaller or bigger. In case of irregular data imports or accumulated scans, the required disk space increases.
BigFix
For disk speed, see: Storage performance requirements.
DB2 for BigFix
For information about hardware requirements for DB2 that is used as the BigFix database, see the Database requirements.
Apart from the disk space that is described in the guide, ensure additional disk space for transaction logs on the computer where the BigFix database is installed. To calculate the required disk space, check how many objects exist in all fixlet sites that you have enabled in the BigFix console. An object is every computer group, analysis, fixlet, and task that exist in the console, including the ones that are not relevant. Every 1000 objects requires 1GB of free disk space. For example, if you have 500 fixlets and tasks, 300 analyses, and 20 computer groups, you have 820 objects in total. Thus, 1 GB of disk space is required.