There is a tradition of arguing against physicalism in the following way: The existence of phenomena F is incompatible with physicalism. But phenomena F is. Therefore, physicalism is false.
He goes on to reject such incompatibility claims, because he doesn't think our acceptance of F (e.g. qualia)'s reality should "hinge on the deliverances of metaphysicians and scientists about whether physicalism is true or false". We shouldn't let the phenomena be held hostage -- and potentially eliminated -- by our metaphysics. I agree. But Andrew's wrong to think that acceptance of the incompatibility thesis entails any such thing.
We might formalize his argument as follows:
P1) Phenomena F are incompatible with physicalism [assume for reductio]
P2) It's an open question whether physicalism is true or false.
C) Therefore, it's an open question whether phenomena F exist.
But C is false, so - Andrew claims - we should reject P1. However, the argument isn't valid. It looks valid, because of the classic confusion of metaphysics with epistemology, whereby one reinterprets the assertion of P1 as the strengthened premise:
P1+) It is known with unshakeable certainty that phenomena F are incompatible with physicalism.
But of course no-one accepts P1+. It plays no role in the incompatibility arguments. There we merely posit P1's truth, not its certainty. And P1 (alongside P2) is perfectly compatible with the falsity of C. This would be so if we were less confident of P1 than we are of F's existence. For consider the inconsistent triad:
1. Phenomena F are actual.
2. Phenomena F are incompatible with physicalism.
3. Physicalism is true.
Further suppose that I have listed these in decreasing order of credence. That is, I am most sure of 1, fairly confident of 2, and much less confident of 3. Then I can use the incompatibility argument to conclude that 3 is false, on the basis of 1 and 2. Nevertheless, I have taken no hostages in doing so. If (per impossibile) I were to learn that 3 is true, then I would reject 2 rather than 1. Acceptance of 1 thus does not "hinge" on 3's rejection.
Andrew's concerns about "hinging" only arise when agents are more sure of the inconsistency than they are of the phenomena. So the fact that he's very confident of 1 is not a good reason for him to be "a compatibilist with respect to physicalism and pretty much everything that we humans care about." Great confidence in 1 by itself gives no reason whatsoever to assign greater credence to 3 than 2, and that is what is required for compatibilism.
So there's another one to file away under "bad arguments for physicalism".
Contrast this with my argument about the ethical stability of atheism. There I made the same kind of argument, that theists have let ethics be taken hostage by their metaphysics. For the same reasons then, a theistic ethicist could avoid my argument simply by allowing that he gives greater credence to moral realism than to the incompatibility of this with atheism. However, very few theists seem willing to endorse this position (instead they claim, "if God is dead, anything is permitted"). So my version of the argument is on stronger ground in this respect.
Thanks for the link, and I like this analysis of the argument.
But when it comes to P1, I think I *have* encountered thinkers who affirm it with quite a bit of certainty (that is, P1+)--especially amongst philosophy students at my University. This is baffling to me, and not just for evidential reasons. I don't understand why anyone would *want* to believe that the existence of something we value hinges on the truth of physicalism. Or determinism, for that matter. So to the extent that desires and values appropriately enter into epistemic deliberation, they undermine the justification for the relevant incompatibility claims.
Well, only if by "relevant incompatibility claims" you mean the strong comparative claim that the incompatibility is more certain than the phenomena's existence. I agree with you on that one, it does seem like an undesirable position to hold. (It's an interesting question whether this should influence our epistemic deliberation, but I guess that's a topic for another day.) But I do want to emphasize that none of this undermines the incompatibility claim (P1) per se. One may be very confident of the incompatibility, but even more confident of F's existence.
The problem is that "physicalism" and "materialism" are moving targets. They are, in my mind, problematic terms.
But one can, I think, show how the properties of some phenomena are incompatible with the kind of talk that some physicalists allow. So I think that in say philosophy of mind this is a very valid way to go (assuming one rejects ontological emergence). Thus there is a difference between first person talk and third person talk and one can say that this invalidates a certain kind of physicalism.
Now you are right that this doesn't convince the physicalist since they'll simply say first person talk is illusionary. Which is fine, but probably not too persuasive to many.
The alternative is to take the approach that matter (and thus physicalism) simply has to include first person talk. Thus the argument can simply be reworked to make a claim about what physicalism must include rather than invalidating physicalism. Thus the problem with physicalism and materialism. There's no fixed meaning.