Click Image to Enlarge
High-temperature polymers are generally defined as those having a long-term service temperature exceeding 300 F. These materials often have other superior properties such as abrasion resistance, chemical resistance, and low-friction characteristics. Examples of such polymers include certain polyamides (specialty nylons), fluoropolymers, polyamide-imide, polyphenylene sulfide (PPS), polysulfones, polyetherimide (PEI), and polyether-ether ketone (PEEK). They are typically processed at temperatures between 600 and 750 F.
Because of the potential uses in high-temperature applications, such as under-the-hood automotive parts, processors are taking a close look at these materials for new business opportunities. However, many older extrusion lines may not be suitable for processing high-temperature polymers.
Before moving ahead, it is essential to understand the special requirements for processing these resins and the limitations of your existing extrusion equipment. In addition to processing issues, there are matters of economics and safety.
In order to bring the extruder and downstream equipment up to the task of processing at higher temperatures, you’ll need heating elements that provide long-term serviceability at elevated temperatures. Ceramic-insulated heaters are typically substituted for standard mica-insulated heaters on all the downstream equipment. While cast-aluminum barrel heaters can still be used, you’ll have to take into account the possibility that the barrel diameter will expand at elevated service temperatures. Air-cooled heaters are generally used in extruding high-temperature polymers. The problem with water-cooled, cast aluminum barrel heaters is that at these extreme temperatures the water almost instantly vaporizes into steam. This results in barrel-temperature instability and creates an issue involving handling the steam as it exits the heaters.
All equipment through which the polymer flows requires more heat to reach the initial startup temperature. In order to reduce startup times, the heaters require higher watt-density than conventionally equipped extruders. Watt-density is defined as the heater wattage/in.² of surface area. Extended warm-up time with low-watt-density heaters can cause additional degradation of the polymer and affect the economics of processing because of longer startups.
In most cases, the time at elevated temperature causes more degradation than the temperature level. In some cases it’s necessary to heat even the normally cooled feed throat to obtain a stable feed rate, as the frictional characteristics of the polymers improve at higher surface temperatures.
Most high-temperature polymers require drying at relatively high temperatures. To reduce the drive power requirement, it’s necessary to retain the drying heat so that the polymer enters the extruder as close as possible to the drying temperature. Since the bulk of the energy from the screw drive goes into raising the polymer temperature, most extruders would be motor-load limited if the polymer were allowed to cool to a significantly lower temperature before entering the extruder. This usually requires high-capacity hopper dryers mounted directly over the feed throat to maintain the polymer temperature.
For example, an extruder processing polyphenylsulfone with the polymer at room temperature would require 80% more horsepower than one processing the polymer at the 350 F drying temperature.
Although insulation of any extruder reduces its energy consumption, this becomes a more critical issue as processing temperatures increase because heat losses to the environment through convection are directly proportional to the difference between the machine and ambient temperatures. For high-temperature polymers, this often makes it necessary to use insulation from the hopper through the die. Also keep in mind that the heat-transfer coefficient for forced-air flow is two to eight times that of still air, so drafts or any direct air flow on the extruder should be avoided to improve stability and reduce the energy requirement.
Because all of the surfaces of the extruder line are much hotter than usual, they require better guarding to prevent inadvertent skin contact when making adjustments or troubleshooting. Protective clothing may be required just to make routine adjustments such as die-flow or screen changes. At these temperatures the slightest contact with a heated surface can cause a severe burn. Any cooling system that contains hot oil or steam must be enclosed to prevent accidental exposure in the event of a leak.
After exiting the die, high-temperature polymers usually require special cooling procedures. If rolls, calibrators, or any type of heat-exchange devices are used, they are usually cooled with oil to avoid the difficulties of vaporizing water. Since the heat capacity and viscosity of heat-transfer oils is substantially different from those of water, this will often require redesign of the whole cooling system. Cooling with water in an open bath or spray may be too severe a temperature shock for these polymers and can cause severe distortion and/or residual stress in the parts. Consequently, air cooling is often used. Since air cooling is not as effective as liquid cooling, additional cooling length may be required, changing the equipment arrangement and floorspace requirement..