Sudden hearing loss can happen out of the blue and without any warning. It might start with the sound of a very loud popping noise that gets quieter and then is followed with dizziness, ringing in the ears and extreme pressure in your head. You could even just wake up in the morning and discover that you can no longer hear out of one ear. Some people may experience a fullness feeling in their ear that’s accompanied by gradual hearing loss.
Sudden sensorineural hearing loss (SSHL) or sudden deafness is an unexplained and very sudden drop in hearing. It can vary in severity and normally only affects one ear (unilateral) but it can happen in both (bilateral), although at the same time is relatively rare. While low-tone SSHL is a widely understand most people experience high-tone SSHL, which has a far worse prognosis.
Sudden hearing loss can be as a result of by several factors including, ear infections, injury to the ear, a build-up of earwax, Ménière’s disease or it can be a side effect of certain medications. But most people who experience sudden hearing loss in one ear are never able to identify the cause. This is referred to as idiopathic SSHL.
Just as with any kind of sudden loss of hearing, particularly when there’s no apparent cause, it should be treated as an emergency. If sudden hearing loss happens to either you or a loved one, then it needs to be investigated and treated as soon as possible. If you wait longer than 72 hours to get help, then you risk the possibility that nothing can be done to help restore your hearing.
Any instance of sudden hearing loss you experience, particularly without any obvious cause, should be examined and treated as soon as possible. An obvious sign of SSHL is the loss of at least 30 decibels in hearing within 72 hours. This would result in normal conversational speech to sound more like a whisper. As the name indicates, symptoms can come on suddenly, or develop over just a few hours or days. You may notice it when you wake up in the morning or notice your hearing seems different when making a phone call or listening to music. Some people say they experience a loud popping sound before their hearing suddenly reduces.
Other symptoms that can be experienced include:
Your doctor will ask you about your symptoms, how long you’ve had them and their severity. They will also ask you questions about your medical history and carry out a physical examination to look for any obvious cause. The doctor will likely perform an audio-vestibular evaluation to help determine if your sudden hearing loss is linked exclusively to a problem in your inner ear. The types of test your doctor will likely want to carry out include:
SSHL is often linked to damage in the inner ear or auditory pathway between the ear and brain. When a person experiences sudden hearing loss in both ears, there could be more than 100 underlying causes. Certain symptoms can act as useful clues in helping to pinpoint what has caused a person’s sudden loss of hearing. If a person experiences repeated episodes of sudden hearing loss or experience it in both ears, the presumed causes are often bilateral Ménière’s disease, autoimmune or metabolic disorders or primary neurologic disorders.
The treatment process for sudden hearing loss will largely depend on the cause. Some cases may simply resolve by themselves after a few weeks for no clear reason. But if you have symptoms of sudden hearing loss, you must get medical advice as soon as possible because the earlier the treatment the more likely you will have a better recovery. As such a high proportion of cases of SSHL don’t have a known cause, the treatment can vary. Some common treatment options include:
Oral steroid therapy and direct intratympanic injection of steroids into the middle ear are becoming an increasingly common treatment. Injecting the steroid in this way allows the medication to flow from the middle ear to the inner ear. High-dose oral steroids are generally recommended to be taken as soon as possible, with people noticing an improvement during the first two weeks. People should be monitored during this treatment in case of any side effects of the steroids.
A study analysing the use of a neuro-rehabilitation approach to treating SSHL found that a new type of sound therapy used in hospitals could provide a safe, easy and effective treatment. This particular therapy motivates people to listen to music intensively through their affected ear while paying auditory attention to that ear.
A woman with SSHL in her left ear was given intensive pharmacological treatment that included high-dose oral corticosteroids over 17 days. Alongside pharmacotherapy, she was given 15 one-hour sessions each day of hyperbaric oxygen therapy. This type of therapy is the only known process for increasing the level of oxygen in the inner ear fluids. Similar to the 20% of people who also received the therapy, the woman reported experiencing temporary near-sightedness, which lessened in six days. She eventually regained full hearing as a result of this treatment.
Your recovery from sudden hearing loss will largely depend on its underlying cause if known. However, other facts also influence how well you recover. Your age, severity of the hearing impairment and the length of time between onset and treatment will have an impact. When treatment is started in the first two weeks after the onset of sudden hearing loss, around 80% of people can expect to see some improvement, while others will recover their normal hearing.
If you drink alcohol or have a blood vessel disease then you have an increased risk of your hearing getting worse and a poor recovery. Some people may benefit from certain lifestyle changes such as high blood pressure, obesity, diabetes and stress, which will help reduce the risk factors associated with sudden hearing loss.
While some people experiencing sudden hearing loss wait for several days or even weeks before getting treatment, the earlier you start treatment the better your chances of recovery. SSHL should be treated within four weeks at the most from when the symptoms first started. Delaying diagnosis and treatment could lead to permanent hearing loss. If you are concerned about your hearing or have experienced a sudden deterioration, schedule a consultation with a hearing care professional or your doctor for immediate treatment.
It's time to finally treat your hearing loss. Sign up for a free consultation with a licensed hearing care professional today to determine if you have hearing loss. It’s the start of your journey towards better hearing.
EarPros benefits: