Beyond language impairment: Profiles of apathy in primary progressive aphasia.
Quang H., Wong S., Husain M., Piguet O., Hodges JR., Irish M., Kumfor F.
Primary progressive aphasia (PPA) is characterised by predominant language and communication impairment. However, behavioural changes, such as apathy, are increasingly recognised. Apathy is defined as a reduction in motivation and goal-directed behaviour. Recent theoretical models have suggested that apathy can be delineated into multiple dimensions: executive apathy (i.e., deficits in maintaining goals and organisation), emotional apathy (i.e., emotional blunting and indifference) and initiation apathy (i.e., reduced self-initiation). Whether the nature of apathy differs between clinical variants of PPA, and across early and late disease stages, remains to be established. Here, carers/informants of 20 semantic variant PPA (svPPA), 15 non-fluent variant PPA (nfvPPA), 16 logopenic variant PPA (lvPPA) and 25 healthy older controls completed the Dimensional Apathy Scale to quantify executive, emotional and initiation apathy. Voxel-based morphometry was used to identify associations between dimensions of apathy and regions of grey matter intensity decrease. Our behavioural results showed greater executive and initiation apathy in late svPPA than in late nfvPPA patients, while late svPPA had greater emotional apathy than both late nfvPPA and late lvPPA groups. Executive and initiation apathy were significantly higher than premorbid levels in all PPA subtypes, while elevated emotional apathy was only seen in early and late svPPA. Distinct neural correlates were identified across apathy dimensions. Executive apathy correlated with grey matter intensity of the left dorsolateral prefrontal and inferior parietal cortices; emotional apathy with the left medial prefrontal, insular and cerebellar regions; and initiation apathy with right parietal areas. Our findings are the first to reveal evidence of the dimensional nature of apathy in PPA, with different clinical signatures observed for each subtype. From a clinical standpoint, these results will inform the development of targeted interventions for specific aspects of apathy which emerge in PPA.