Purpose
The purpose of this program is to display RGB colors as a function of wavelength for visible light (380 to 780 nm). A secondary purpose of this program is to display the emission and absorption spectra of hydrogen. The upper and lower wavelength limits for the spectrum can be interactively specified, and interval marks can be displayed if desired. A spectrum can be printed or saved to a 24-bit color BMP file.
Disclaimer
There is no unique one-to-one mapping between wavelength and RGB values. Color is a wonderful combination of physics and human perception. Please consult a textbook, such as Principles of Color Technology by Billmeyer and Saltzman, for a better understanding of color. In particular, I like the way Billmeyer explains color as the product of three curves, since color requires a light source, an object and an observer. The values shown in this project should only be used as approximate colors, for example, in false color schemes.
Materials and Equipment
Software Requirements
Windows 95/98/2000
Delphi 3/4/5 (to recompile); need "Professional" version for TChart component
Hardware Requirements
Best when run with a high color or true color display (but will work with only a 256-color display).
Procedure
Discussion
The WaveLengthToRGB function is based on Dan Bruton's work () and is in the file SpectraLibrary.PAS, which is part of the download set:
The product of wavelength and frequency gives the speed of light, c = 2.9979 x 108 m/sec. Given the linear wavelengths (in nanometers) on the Visible Light tabsheet, the frequency values are computed (in TeraHertz). While the wavelengths in the spectrum bitmap are linear, the frequencies are not.
The wavelengths of the Balmer series for n = 3 to 9 are calculated once by the FormCreate method.
The Balmer emission spectra for hydrogen is computed from this formula:
where n = 3, 4, 5, ...
The general hydrogen emission series can be computed from this formula:
where
RH = Rydberg Constant for Hydrogen = 10,967,757.6 m-1.
n=k+1, k+2, k+3, ...
and k is defined in the following table:
For additional details of the hydrogen spectra (and other atoms and molecules) see a good physics book, such as Quantum Physics of Atoms, Molecules, Solids, Nuclei, and Particles (2nd edition) or Quantum Chemistry (5th edition).
Most changes in the user interface result in a call to UpdateImage. If the hydrogen emission/absorption spectrum is to be displayed (see below), a set of flags for each pixel column is set to tell if each column is in the Balmer series..
The TChart component was used to display the R, G, B functions of wavelength.. The StretchDIBits Windows API call was used to make sure colors look good on any printer.
The Brightness, Y, shown in the graph on the RGB tab was computed using the formula:
Y = 0.299R + 0.587G + 0.114B
The coefficients in this equation properly compute the luminance for monitors having phosphors that were contemporary at the introduction of NTSC television in 1953. Contemporary CRT phosphors are standardized today with CIE luminance from linear red, green and blue to be:
Y = 0.212671R + 0.715160G + 0.072169B
See Charles Poynton's FAQ about Color and Gamma, section C-9 for more information:
See Paul Bourke's Spectrum image:
See how to use a "Rainbow" to color Lyapunov Exponents, which includes a slightly newer SpectraLibrary but requires Delphi 4.
For information about Color Science, see efg's Color Reference Library pages.
Conclusions
The WaveLengthToRGB function in the SpectraLibrary.PAS unit will be very useful in assigning colors to visible wavelengths of light, or any many applications needing false colors.
Keywords
Visible Light Spectrum, Hydrogen Emission Spectrum, Balmer Series, Hydrogen Absorption Spectrum, WavelengthToRGB function, TChart, Scanline, TRGBTripleArray, Print BMP, StretchDIBits, OnMouseMove, GetRValue, GetGValue, GetBValue
References
Dan Bruton's Color Science page,
Rendering Spectra,
John Walker's Colour Rendering of Spectra,
Mitchell N Charity's comments about this article
Don KlipStein's Spectra,
Download
Delphi 3/4/5 Source and EXE (236 KB): Spectra.ZIP
Delphi 3 EXE: 435 KB
Delphi 4 EXE: 543 KB
Delphi 5 EXE: 578 KB
Updated 31 Jul 2006
since 1 Nov 98