Long Beach Needs This: City-Owned Big Lots for Smaller Developers
Long Beach Needs This is a series that addresses.
****
Photo by Brian Addison. Construction cranes loom over DTLB.
Let’s be frank: the Unaffordability Beast is rearing its ugly head throughout California, including right here in Long Beach. It is doing everything from displacing folks to prompting Oakland to issue a moratorium on rent hikes and evictions to creating subsidized housing for those making $250K/year in Palo Alto. (You read that right.)
Affordability—or a lack thereof—is complex, revolving around how much a certain area is developing, what kind of development they’re building, incentives for making those developments affordable, surrounding businesses (or the possibility of new ones coming in), transit, jobs, education access… It isn’t just about one thing or another. And every single one of the aforementioned issues revolve around urban design.
Rents are skyrocketing in Long Beach. Houses are now commonly reaching $1M. And while it is certainly still cheaper than LA–much cheaper—Long Beach cannot single-handedly solve the region’s (or state’s or nation’s) housing crisis.
But there are ways we can alleviate it, even if these forms of alleviation are sadly reserved for the future.
Take, for instance, the Long Range Management Property Program (LRPMP), the City of Long Beach’s much-lauded ridding of its former redevelopment properties after the dissolving of the Redevelopment Agency. Each lot was sold to a single developer, brought a huge influx of cash into the City’s coffers and some much needed housing. (A favorite amongst everyone from the Mayor himself to property owners; of course, each remains mum on the measly amount of affordable housing attached to all this development; thus far, of the thousands of units online or in the pipeline, only a few hundred are affordable and less than 20 of those are within the Downtown core—y’know, the place that is most walkable, most easily accessed with transit both in and out of Long Beach, and the main source of density for future building. If we are to stretch to the Downtown’s outermost edge—and I mean that literally because this development is at 12th and Long Beach Blvd.—there is the two-structure Beacon Apartments which add 121 affordable units for seniors and 39 units for formerly homeless veterans.)
It’s an easy way to attract developers: “Come, snatch this massive piece of land and build an equally massive housing development!”
The result of the LRPMP was a swath of Long Beach land handed to massively wealthy developers that resulted in a plethora of homogenous new housing: mostly multi-family, mostly luxury, mostly market-rate, mostly a similar aesthetic. (And yes, I know my criticism is indeed coming from the same dude who constantly screams density and height in the urban core—but I also fight for variety of development, of mixed land uses, even of mixed economies.)
This was all state-mandated, mind you. So it isn’t the Mayor’s fault, the City’s fault, or… It is our collective fault for not questioning it; it is my own fault for not examining it closer as an urbanist.
But what if the city had sold off larger lots to multiple smaller developers rather than single large developers? The results could have actually been quite spectacular and it’s something we should look into in terms of future development. It would create what urbanist Andrew Price calls “fine-grained urbanism,” that is, spaces that are diverse in size, property owners, renters, and density.
“A fine-grain urban core means many lots owned by many people,” Price said. .”
The benefits? Diverse property ownership, a lower cost of entry (allowing “the ability to build a shop or a home on a small narrow lot for a smaller cost compared to building an entire apartment complex,” Price said), a varied amount of places to visiting by foot, and the best part: less bad architecture—after all, it’s easier to rebuild a smaller building than a monolithic one.
This even solves multiple problems, both within and without Long Beach’s downtown core.
For one, it provides an investment amongst people who really desire to make it but can’t afford $9M for a swath of land—and yes, I know that it doesn’t provide a potential investment for everyone but it certainly doesn’t make turn a city’s most valuable resource, land, into a resource solely for the wealthy.
Most importantly? Here’s how Price says it: “We will be returning to a development pattern that helped produce the lovable, high quality urban neighborhoods we have today. We signal to the people that the city wants them involved in developing our city, not just the big developers with dozens of millions of dollars to invest.”
This even extends to the “missing middle” architecture that every American city is lacking: not the suburban sprawl subdivision, not the high-rise tower, but the middle option. Two-story townhomes in a complex of a few hundred that may have a small patio, if not one shared by many, and a feeling of ownership.
As new families are priced out of single-family homes—my jaw dropped when I saw a house at 3rd and Temple go for over $1M—and forced into tiny apartments… As Baby Boomers go through the guiltlessness of their nightmarish decisions and finally decide to downsize… As lower- and middle-income Americans struggle to pay climbing rents due to an influx of the aforementioned homogenous, market-rate, luxury housing being built in DTLB…
The “missing middle”? It’s the alternative of Brooklyn to Manhattan. And it could be the alternative of, say, Alamitos Beach to DTLB—it all just depends on creating it.
Ultimately, Long Beach’s development story is one of two separate tales. On one hand, we are changing in a way that is making our downtown core the one it always should have been—dense, bustling, tall—while development there lures development into far more needy neighborhoods like West and Central Long Beach. On the other hand, a swath of City-owned property unilaterally being handed to massive developers that look toward creating homogeny rather than diversity in the name of speed, a Long Beach “boom,” and the hopes to secure a ton of money.
There is no reason we can’t simultaneously address both of these tales, to proceed with caution but not outright rejection, to move forward with everyone and not just a few.
Let’s not be late again.