by David Williams | SAPinsider
April 1, 2010
Last year, SAP made SAP BusinessObjects Planning and Consolidation 7.0, version for SAP NetWeaver, generally available at the best possible time. It was April 2009, and companies struggling with the aftermath of the global economic crisis needed a solution to help them become more agile in their planning processes. They needed to adapt to dynamic market conditions yet keep costs in check by leveraging their existing infrastructure components and skill sets.
One year later, SAP continues to deliver on all counts with the latest iteration of the solution: SAP BusinessObjects Planning and Consolidation 7.5, version for SAP NetWeaver. The enhanced solution is the only unified planning, budgeting, reporting, and consolidation product that is tightly integrated with the SAP NetWeaver platform, yet is still designed to be owned and managed by the business user.
There are a number of enhancements and new features in the 7.5 release of SAP BusinessObjects Planning and Consolidation, version for SAP NetWeaver, to help you deliver insight from your entire system landscape. This article focuses on three of them.
With this article and stories like it (to follow in future issues of SAPinsider), readers will learn how to wield their enterprise performance management (EPM) and governance, risk, and compliance (GRC) efforts for strategic and competitive advantage.
In a typical organization, planning and forecasting can be time-consuming, cumbersome, and inaccurate. Companies spend an inordinate amount of time and resources attempting to collaboratively input, collect, aggregate, and report on their information.
To alleviate this resource drain, business process flows (BPFs)1 provide controllable, consistent, and collaborative planning and consolidation processes, while simultaneously delivering guidance to individual contributors. BPFs enable the finance organization to implement processes across the enterprise by designing the logical flow, reviews, and approvals needed to drive planning and forecasting exercises.
Customers have two different BPF views to choose from. The Monitor view within SAP BusinessObjects Planning and Consolidation, version for SAP NetWeaver, is a global view enabling executives and reviewers to see the progress of a process (or processes) across the entire organization. Within this view, a user can:
Alternatively, the My Activities view provides a personalized view of step completion status and activities assigned to a specific user. Through this view, the owner or contributor can visualize a personal “to do” list of processes that are in progress and require attention (see Figure 1).
In the 7.5 release of SAP BusinessObjects Planning and Consolidation, version for SAP NetWeaver, users can now drill-through to source systems to explore detailed information on transactions without having to replicate data in the SAP BusinessObjects Planning and Consolidation application.
This drill-through capability enables users to access data in various targets, including:
To help users get up to speed quickly on this capability, the solution includes a configuration wizard to assist with the creation of drill-through paths (see Figure 2).
SAP BusinessObjects BI solutions — including Xcelsius, SAP BusinessObjects Web Intelligence, and SAP BusinessObjects Explorer — are a powerful ally for finance organizations responsible for planning and forecasting. Now users can leverage these BI solutions to access information directly from SAP BusinessObjects Planning and Consolidation so that information can be shared with users beyond the realm of the finance group over the Web. Companies can also leverage these investments for a common reporting interface across all sources of information in the organization. Access is made even easier with the single sign-on capabilities and multiple authentication types that are supported via the Central Management Server (part of the SAP BusinessObjects Enterprise platform).
By integrating SAP BusinessObjects BI tools with SAP BusinessObjects Planning and Consolidation, version for SAP NetWeaver, customers can benefit in the following ways:
By expanding the reach of SAP BusinessObjects Planning and Consolidation, SAP gives companies the ability to improve agility, reduce cycle time, and increase user productivity.
The latest release of SAP BusinessObjects Planning and Consolidation, version for SAP NetWeaver, expands the value of the solution for both business and IT professionals. Business users, including those in finance, will benefit from embedded process flow capabilities and increased insight into information, while IT professionals will be better positioned to leverage their existing skill sets and technology investments. Both groups are better able to focus on the high-value projects that drive a company forward.
Please visit for more information about SAP BusinessObjects Planning and Consolidation, version for SAP NetWeaver.
David Williams (david.williams@sap.com) is Director of Solution Marketing, responsible for SAP BusinessObjects Planning and Consolidation. He has worked in product and marketing-related roles at a number of business intelligence and performance management software companies. You can see David regularly speaking at user conferences, industry shows, and on webcasts.
1 Business process flows are a series of business process steps, which can be tailored to your organization's specific needs, that must be completed in sequential significantly improved overall SAP BusinessObjects Planning and Consolidation performance and user experience by seamlessly upgrading to version 10.1 on SAP HANA
Financials: Case study: How National Vision implemented a dynamic forecast process with SAP BusinessObjects Planning and Consolidation.