Last week was an exciting one for connoisseurs of green infrastructure finance, when the District of Columbia Water and Sewer Authority (“DC Water”) made green infrastructure history by using an “Environmental Impact Bond” (EIB) to fund the construction of green infrastructure to manage stormwater from twenty impervious acres in two District neighborhoods. Green roofs, porous pavement, and rain gardens are all examples of green infrastructure practices, designed to manage rain where it falls, allowing it to filter back into the ground or evaporate back into the air. These alternatives totraditional “pipe and cement-based” stormwater management practices are becoming more mainstream in municipal stormwater management strategies, with cities large and small committing to specific “greened acre” goals. For example, New York City has committed to utilizing green infrastructure to manage stormwater over 8,000 impervious acres, Philadelphia will “green” 10,000 acres, and Milwaukee and Seattle will do the same with upwards of 20,000 acres.
Many impact investors are familiar with Social Impact Bonds (SIBs), as they have been used in recent years to help meet public policy goals such as reducing recidivism or homelessness. What’s new here is the application of the SIB structure to an “environmental” outcome --- in this case, stormwater management, and what’s exciting is that, because it reduces some of the financial risks a city would otherwise take in opting for "green" strategies, the EIB structure could be a way for more cities to “go green.” The basic structure of the DC Water EIB is as follows:
1) In 2016, DC Water enters into a contract with investors (in this case, Goldman Sachs and the Calvert Foundation) whereby the investors provide $25 million to DC Water to constructgreen infrastructure to manage stormwater from 20 impervious acres (in this case, porous pavement and bio-retention will be built). DC Water will also undertake an evaluation program that includes: a) pre-construction monitoring of stormwater runoff in the locations where the green infrastructure will be built; b) modeling to identify a range of expected performance outcomes; and c) post-construction monitoring using the same methodology which was used pre-construction.
2) After the green infrastructure is built, in the year 2021 (the term of this particular contract is 4.5 years) it’s time for DC Water to repay its investors – the precise amount they must pay will depend on how well the installed green infrastructure assets perform against the range of outcomes modeled before construction. If, for example, the assets fall short of the target performance range, DC Water will repay its investors $21.7 million at the mandatory tender date. If, on the other hand, the project performs better than projected, DC Water will pay investors back their principal $25 million, the remaining accrued interest at the 3.43% interest rate agreed to by the parties plus an additional $3.3 million. If the project performs in the middle range of the modeled outcomes, DC Water simply pays the investors back the same amount they were provided upfront ($25 million) plus any remaining interest. More details on the contractual terms can be found in this helpful fact sheet.
A financing structure where repayment is dependent in part on project performance is appealing because it reduces the financial risk that a city or utility would otherwise need to assume in installing green infrastructure to meet its water quality goals. Some cities aren’t comfortable trying something new and may be reluctant to replace the tanks and tunnels that they have been using with trees and gardens..
To be clear, an EIB/pay-for-success contract is not “free” money—no more than a traditional municipal bond is “free”—because in both cases, the promise to repay is backed by the full faith and credit of a city’s balance sheet or by a specific revenue stream (such as stormwater fees). For those of us interested in green infrastructure finance, the EIB structure is exciting because it’s a way to help cities (especially those that might otherwise be worried about project performance) to try integrating green infrastructure into their stormwater mitigation and water quality goals.
Let’s consider the conventional municipal financing alternatives to the EIB. If DC Water had chosen to use a more traditional route to fund its green infrastructure through directly using bond proceeds, city general funds, or ratepayer funds, they would most likely have had to pay for the entirety of the project regardless of project performance, because that is how most municipal procurement tends to work. The EIB is helpful and different because it ties a project’s spending to its success. In principle, a city could write a similar performance-based contract for any private-public-partnership, but the terms of those contracts can be complicated and the negotiations between the private entity and the municipality can be lengthy. Some places, such as Prince George’s County, have managed to strike P3 deals that do pay on a performance basis. However, for the vast majority of municipal stormwater procurements, cities usually pay up front and, in doing so, assume all project risks.
The good news is that any project where a range of outcomes can be reliably modeled in advance of an intervention is a good candidate for an EIB. Now that an EIB has been done for green stormwater infrastructure, one can imagine future applications to other water infrastructure challenges, such as drinking water quality or water efficiency, as well any case where municipalities stand to benefit greatly from distributed “green” approaches but may be too risk-averse to try them for the first time. A city that has a robust water infrastructure grant program (be it focused on water efficiency or stormwater management) targeting private property owners, such as Seattle, southern California, or Milwaukee, could even consider financing that grant program through an EIB structure, coupling the risk-mitigating benefits of a pay-for-success model with the low-cost distributed infrastructure opportunities that can be found on private land.
The Harvard Government Performance Lab (GPL), which provided technical assistance on DC Water’s EIB, will be continuing to partner with public sector leaders in obtaining better results from their social program spending—whether through an EIB, an SIB or other pay-for-success model, including, but certainly not limited to, water infrastructure projects. Check out theirnew request for proposals—awardees will benefit from GPL fellows offering pro bono technical assistance to structure and deploy results-driven contracts.
Alisa Valderrama, Senior Policy Analyst, Water Program