At least one-third of Colorado’s 64 counties – encompassing vast stretches of ranchland on the state’s Eastern Plains and Western Slope – lack veterinarians needed to care for sheep, hogs, dairy cattle, and beef cattle that are essential to food production and to the well-being of rural economies and communities.
The dearth of rural veterinarians is a growing concern, not only in Colorado but in livestock- producing regions nationwide. It means animal welfare worries and economic losses from livestock illness and death. The veterinary shortage also weakens a critical front line for public health because vets detect and monitor diseases that can spread from animals to people, such as Salmonella infections, West Nile virus, rabies, and plague.
But a new state program, administered with staff support from CSU’s College of Veterinary Medicine and Biomedical Sciences, seeks to curtail the problem by helping repay college debt for veterinarians who pledge to practice livestock medicine in underserved agricultural communities Addressing the issue at its financial roots is expected to beef up the ranks of rural veterinarians.
The Colorado Veterinary Education Loan Repayment Program, like similar programs for medical doctors, tackles a core problem: Many rising veterinarians want to practice large-animal medicine in rural communities but cannot afford to do so. Indeed, many regions that lack veterinarians also lack doctors – for similar reasons, Dr. Mark Stetter, dean of the CSU College of Veterinary Medicine and Biomedical Sciences, said.
That’s largely because the average educational debt for veterinary school graduates is nearly $144,000, according to the latest estimates from the American Veterinary Medical Association. And more than 20 percent of recent veterinary graduates have college debt surpassing $200,000, the association reports. Bottom line: Many veterinarians simply cannot repay college loans with the relatively low salaries offered for livestock practitioners in rural communities. They have been priced out of the field.
The debt-to-income ratio among recent veterinary graduates is a leading industry concern and is closely tied to rising nationwide tuition costs, among other factors.
The Colorado Veterinary Education Loan Repayment Program will provide $70,000 over four years for each awardee. The program is accepting its first round of applications through Oct. 31; the first two recipients will be named in early December.
“Much of rural Colorado is a long way from a practicing veterinarian. It’s a real problem,” said Scott Johnson, chair of the recently established council that runs the Colorado Veterinary Education Loan Repayment Program. “This program is a real win for new veterinary graduates who want to practice in rural Colorado, and it’s a real win for production agriculture.”
Johnson oversees his family’s sixth-generation cattle operation, Flying Diamond Ranch, near Kit Carson on the state’s Eastern Plains. The ranch is in a federally designated veterinary shortage area, and Johnson sees the effects firsthand.
Like most ranchers, Johnson and his crew do lots of basic doctoring themselves. But “we’ve had some life-threatening situations that are pretty critical” – and the severity is heightened without a nearby veterinarian to call upon, Johnson said.
His animals with medical emergencies must be hauled by trailer at least 60 minutes for treatment, Johnson said. That’s the case when a cow has a calf with an abnormal birth presentation, or when a ranch horse suffers a potentially fatal bout of the intestinal condition known as colic. Lack of veterinary access can be the difference between life and death, said Johnson, a CSU alumnus and past member of the University’s Board of Governors.
Dr. Kayla Henderson, a 32-year-old veterinarian in southern Colorado’s San Luis Valley, views the loan-repayment program from the perspective of a young practitioner.
“It’s huge,” she said of the program’s importance.
Henderson is vice chair of the program council. She also typifies future awardees: Henderson is a 2012 CSU veterinary graduate and a third-generation cattle rancher who returned to Monte Vista, her hometown, to provide medical care for cattle, horses, and other animals. She would have been hard-pressed to fulfill that girlhood dream, Henderson said, without support from a federal loan-repayment program that serves as a model for the new state program.
Her typical work day includes handling difficult births, performing cesarean sections, caring for uterine prolapses, pregnancy checking, testing bulls for breeding soundness, treating bloat and colic, medicating pneumonia and other infections, performing castrations, and providing lameness evaluations and treatments.
“What I’m really excited about is we want to help people financially, specifically people who will stay in these rural places,” Henderson said. Program directors will look for applicants who want to build careers working with livestock and ranchers in agricultural settings – those who “have grit and can stick,” she said.
Officials anticipate that many awardees will be young veterinarians, like Henderson, who grew up in rural Colorado and want to return home.
“I’m confident we can provide this funding to veterinarians who will have a positive impact on their communities,” said Dr. Keith Roehr, state veterinarian with the Colorado Department of Agriculture, who also serves on the program council.
The Colorado Veterinary Education Loan Repayment Program was established in June 2017, when Gov. John Hickenlooper signed into law a bill sponsored by state Sen. Jerry Sonnenberg, a Republican of Sterling, and state Rep. Joann Ginal, a Democrat of Fort Collins.
The law establishes a council composed of five governor-appointed members representing agriculture, education, and veterinary medicine. This council, with staff support supplied by the College of Veterinary Medicine and Biomedical Sciences, will accept and review applications, and will name awardees according to criteria outlined in the state statute. In the program’s first cycle, the council will select two awardees; that number may rise if the state allocates additional funds to the program, officials said.
For information about the Colorado Veterinary Education Loan Repayment Program, visit col.st/dvmloanrepayment.