Forbes.com
This article originally appeared on Forbes.com.
The idea of “emotional quotient,” or EQ, is making a surprising comeback in the business world. Also called emotional intelligence, EQ is the ability to understand other people, what motivates them, and how to work cooperatively with them. Worthy enough, but why would this be rising in importance at a time when we are so focused on advances in artificial intelligence, the impact of increased automation, and the possibilities of machine learning? As machines increasingly take over jobs and complex decisions once the exclusive domain of people, it would not be so far-fetched to think that we are entering a “post-human” or at least “post-EQ” world.
Instead, and perhaps ironically, digitalization is fueling a renaissance in EQ. As digitalization, broadly defined, continues its revolutionary march through the business world, it brings profound implications for the human workforce. If we thought EQ was an “or,” it’s actually turned out to be an “and.” Rather than sideline EQ, digitalization has actually made it more important.
Let’s look first at the data (of course). The evidence shows that if you care about generating and sustaining results in your business, you should also care a whole lot about EQ. A recent study by my colleagues at Bain & Company found that companies that achieve or outperform their stated ambition are focused on the “people” side of the ledger, and significantly so. Culture, behavior change, management alignment, and dynamic capability building surface to the top as critical factors for success. This remains true even as we increasingly automate our businesses. A 2018 study from Singapore Management University found 87% of respondents agreed that culture created bigger barriers to digital transformation than technology, and 80% of C-Suite interviews highlighted the importance of purposefully focusing on “people aspects” during digital transformation journeys.
My recent experience with a large multinational bank is a good illustration of EQ’s revenge. Technology is dramatically changing the banking industry, especially on the retail side. Like most of its peers, this particular bank knew it would need far fewer retail branches as banking moved to phones and online. The CEO hired a chief digital officer, invested millions in a new online platform, and had grand plans to move a significant portion of its customer base toward internet banking.
But as the boxer Mike Tyson once famously said, “Everybody has a plan ‘til they get punched in the mouth.” The bank’s numbers just didn’t move as they were supposed to, frustrating and perplexing the executive team. Despite all the money put into the new, impressive digital platform, employees and customers kept doing a lot of what they’d always been doing. To change behavior, the bank’s employees needed new skills, and their customers needed new routines. None of this was in “the plan,” but it didn’t take this management team long to realize that to accelerate progress, they needed to think about the problem from the human perspective—that of the customer and employee—not just from the standpoint of what was technically possible.
As management shifted focus, the numbers started to improve. Managers realized, for example, that if a customer representative in a branch engaged at least once a day with an online adviser to resolve a customer issue in real time, both the employee and the customer became more comfortable with the new digital platform. As a result, the company began to realize more of the expected savings, customers grew to appreciate the convenience of online banking, and branch employees gave better service. Subsequent leadership debates shifted from pure technology to more human considerations. After all, organizations don’t adopt technology, people do.
With technology increasingly automating routine white-collar tasks, the ability to apply human judgment, inspiration, and creativity carries an even higher premium. Consider, for example, the demographic and societal changes fueling the next generation’s desire to work with organizations with a clear and compelling mission. Part of the psychology behind this shift is the natural human desire for stability and predictability. Against the backdrop of technology-driven change and workforce fluidity, a strong and unchanging organizational purpose or mission provides a solid foundation. Emotional connection, empathy, and the capacity to motivate all take on new importance.
Business concepts that have their roots in technology, like distributed innovation, can also require new ways of managing and unlocking human ingenuity. I hear this all the time from executives across industries, including in the not-for-profit sector. Medair, a global emergency relief and humanitarian nongovernmental organization I collaborate with closely, illustrates the value of pairing distributed innovation with a front line that displays strong EQ. To bring innovative sanitation, health and energy solutions to those in greatest need in areas devastated by conflict, drought or natural disaster, Medair leverages its people-to-people orientation on the front lines. It brings insight and innovative ideas from the field back to headquarters, where Medair taps into a strong network of technologically cutting-edge institutions, both academic and private. Collaborating with these universities and organizations, Medair has developed effective approaches to such critical challenges as clean drinking water and proper nutrition.
Clarity on how digital disruption affects your industry and your business is critical. It is even more important to develop a clear picture of the implications for your workforce, their required capabilities, and your leadership style. Just when one might have thought technology was taking over, human considerations have assumed new forms and importance. Think of it as EQ’s revenge in the digital age.