The past two decades have seen globalization of the world’s wine markets proceed like never before, in both speed and comprehensiveness. There was a degree of trade expansion in the five decades to World War I but, until the late 20th century, interactions across continents involved little more than the exporting of vine cuttings and traditional production expertise. Indeed most wine was consumed in the country of production, and those countries were mostly in Europe.
The fall in transport and communication costs since the 1980s is largely responsible for the change. That has made it affordable for many more producers to focus on exports, and for some to also focus on mergers or acquisitions.
Falling international trade costs and de-regulation of liquor retailing have also allowed large supermarket chains to become buyers of both bottled or bag-in-box wines and wine for building their own brands.
Retailing through such chain stores requires large quantities of homogenous wine year after year. Producers in the New World were more adept at initially responding to this new demand, creating a huge new category of robust, fruity ‘commercial premium’ wines that fall between expensive fine wines and cheap non-premium (‘table’) wines.
The share of global wine production exported, which had always been below 15 per cent and mostly Mediterranean or intra-European, grew dramatically from the late 1980s. By 2012 it exceeded 40 per cent.
The New World’s share of global wine exports rose from 3 per cent in the late 1980s to 25 per cent (if sparkling wine is excluded) by 2004.
Recognizing their poor performance, Europe’s producers during the past decade have been adapting their practices to compete. The three leading European wine-exporting countries as a group now export almost half their production, up from just one-fifth a generation ago.
Simultaneously, New World producers are seeking to expand their exports of more-expensive wines to complement their lower-end products. The next phase of wine’s globalization therefore may involve a convergence whereby both groups produce terroir-driven super-premium wines alongside more-affordable ‘commercial premium’ branded wines. Meanwhile, cheap basic non-premium wines are continuing their demise.
Technological developments are rapidly altering the means of exporting commercial premium wines. In the past decade or so the share of wine that is exported from the New World in bulk shipping containers has risen from less than 15 to more than 40 percent. Bottling in the country of destination is sometimes cheaper, and it lowers the cost and carbon footprint of shipping. By shipping in 24,000-litre bladders to fit 20-foot containers, this new technology offers greater opportunities to blend wines from any region of the world.
Greater openness to trade means winemakers and hence grapegrowers are far more exposed now than pre-1990 to exchange rate volatility, and also to greater import competition in their domestic market as consumers seek to choose from an ever-broader range of wines. Wide fluctuations in exchange rates since the global financial crisis began in 2008 have substantially altered national shares in key markets.
Greater openness and international travel also alter tastes and preferences. Nowhere has this been more obvious in the case of wine than in China. Chinese wine imports grew more than 50 percent per year during 2006-12. With the number of middle class in China currently around 250 million and growing at 10 million per year, and with grape wine accounting for less than 5 percent of alcohol consumption, further large increases in wine consumption are expected. How much of that Chinese demand will be supplied by domestic producers is difficult to guess, but import growth is likely to continue for the foreseeable future (see Wittwer and Anderson 2015).
Recent Comments
[…] professor Kym Anderson reports on the continued globalization of the wine business and paints a picture of what the future looks […]