Tech Tip: Weak Fuel Pump Can Cause Engine to Misfire
By Larry Carley
Technical Editor
The fuel pump is the heart of the fuel system. On most late-model vehicles, an electric pump is mounted inside the fuel tank to supply fuel to the fuel injectors. The pump runs continuously after the key is turned on and the engine starts — unless something goes wrong with the pump and it quits. A fuel pump failure causes the engine to stall and will prevent it from restarting.
Back in the days when engines had carburetors, replacing a fuel pump was not a big deal nor a major expense. The pump was mounted on the side of the engine and usually sold for $20 or less. Diagnosis was relatively simple, too. If it leaked or failed to pump fuel to the carburetor, it was bad.
With electric fuel pumps, it’s a different story. The pumps typically cost $150 to $300. The in-tank location also makes them difficult and expensive to replace. Labor alone can add a couple hundred dollars to the repair bill. Diagnosis can also be a challenge, even for experienced technicians.
For a fuel-injected engine to run properly, the fuel pump must be capable of generating pressure that meets the system’s operating requirements. Close enough is not good enough. The pressure delivered by the pump must meet specifications because that’s the way the engine is calibrated to run. If fuel pressure is even a couple pounds less than the specifications, it can cause problems. A weak pump that isn’t delivering adequate pressure can cause an engine to run lean, misfire and hesitate when accelerating.
The volume of fuel is just as important as pressure. A good fuel pump is usually capable of pumping at least 750 ml (3/4 quart) of fuel in 30 seconds. If it can’t, there’s a problem. The pump might be getting wear, a clogged fuel filter might be restricting fuel flow to the engine, or the pump might not be getting enough volts through its power circuit to run at normal speed. Loose or corroded wiring connections in the pump circuit, a bad relay or low system voltage can all affect the operation of the fuel pump.
Low fuel pressure can be caused by any of these factors, as well as a bad fuel pressure regulator. The regulator is a small valve with a spring-loaded diaphragm inside. The regulator’s job is to control fuel pressure to the injectors.
On most applications, the regulator is mounted on the engine’s fuel injector supply rail. But on engines with “returnless” fuel injection systems, the regulator is located in or on the fuel tank near the fuel pump. On the engine-mounted applications, the regulator has a vacuum line connection to the intake manifold. At idle, high vacuum in the intake manifold causes the regulator to bleed off fuel pressure and route the excess fuel back to the tank through a return line. As engine load increases and vacuum drops, the regulator bleed off less pressure to maintain the same relative pressure differential between the injectors and intake manifold.
If the regulator leaks internally, it may bleed off too much pressure, causing symptoms that mimic a bad fuel pump. Consequently, if the operation of the regulator isn’t checked, someone may replace the fuel pump unnecessarily. The regulator can be checked by pinching off or disconnecting the vacuum hose. This should cause an increase in fuel pressure. If fuel pressure is low, and pinching off the return line causes it to rise to normal levels, the regulator is leaking and should be replaced.
All too often, these “other” causes are overlooked and the fuel pump is replaced unnecessarily. Misdiagnosis is a major issue with electric fuel pumps and costs everybody time and money. Unfortunately, to date there has been no easy way to bench test an electric fuel pump. Pump pressure can be tested on a vehicle by connecting a fuel pressure gauge to the fuel rail service connection or the fuel rail supply line. Fuel volume can be measured by disconnecting the supply line to see how much fuel the pump can delivery in 30 seconds, or by measuring fuel flow with a special flow meter.
WHY GOOD PUMPS GO BAD
A fuel pump is engineered to last the life of a vehicle, but it often fails to go the distance because of other factors. Dirt or rust inside a fuel tank can ruin a pump very quickly (which is why the fuel tank should always be inspected and cleaned or replaced if any contaminants are found inside when replacing a fuel pump).
Many motorists also have a bad habit of driving around with a low fuel level in their tank (under 1/4 tank). This can shorten the life of the pump and cause it to fail prematurely because the pump relies on the fuel for cooling and lubrication. Fuel tanks have internal baffles that are supposed to minimize fuel sloshing. Even so, whipping around a sharp corner, or braking or accelerating hard can sometimes starve the pump for fuel. And when the pump sucks air, it suffers the consequences.
As a fuel pump ages and its brushes wear, the pump may pull more amps than normal thorough its power supply circuit. This may cause the pump wires to run hot and melt or short out! If the damaged wiring harness is not replaced when the pump is changed, the replacement pump may not work at all or may not spin fast enough to generate normal pressure.
The fuel pump is part of the fuel tank sending unit assembly. The pump can be replaced separately (which costs less but requires more work and increases the risk of misassembly), or it can be replaced as a complete assembly (much easier but costs more).
Note: Some replacement pumps may not look exactly the same as the original. The reason for this is that some aftermarket pump suppliers have replaced “old technology” pumps with newer “turbine” style pumps that are more efficient and reliable.
The fuel strainer sock on the fuel pump inlet inside the tank should always be replaced with a new one when changing a pump. Also, if the old fuel tank is rusty, it should be replaced to prevent a repeat pump failure. The fuel filter should also be replaced.