Exploring Charge Codes in AX 2012: Part 1
In this post I’m going to expand upon basic use of Charge Codes in Dynamics AX 2012. There are more than a few ways to leverage this feature!
In an earlier post my co-worker, Wally, demonstrated the setup of charge codes.
First we are going to work with automatically bringing the Deposit charge code to purchase orders at the time of creation.
In our example, we are purchasing a product that is shipped in a 55 gallon plastic drum. The manufacturer charges a refundable deposit for these containers.
Rather than just setting up a charge code to be used to manually for this fee, I would like to make this a bit more visible to the buyer when they create the purchase order.
There are a number of ways to accomplish this. For our purposes, the following steps will be taken.
Step 1: Set up an Item Charge Group.
Set up for this step was done from Procurement and sourcing/Setup/Charges.
Charge groups must have a name and a description. The charges group name may be alpha, numeric or mixed. In our example, I have created a charge group named “Deposit”.
Since this is an Item Charge Group that I have created, I will assign this group to the product that is purchased in the refundable containers.
From the menu, I go to Product information management/Common/Released products and locate my product. Then I click the edit button. When the screen opens, I scroll down to the Purchase section. In the Charges group field, I select Deposit from the drop down list.
Step 2: Procurement & Sourcing
The next step is to go back to Procurement and sourcing/Setup/Charges and work with Automatic charges.
1. Automatic charges may be set up at the header level or the line level. I have chosen line level for a few reasons. A) It allows other products that have been assigned the Deposit charge group to each have a charge calculate. B) It allows handling of the credits granted for the returned poly drum credits to be managed at the header level.
2. Since this product is available from multiple vendors, I have selected the value of ALL.
3. Selection of Group allows me to choose the newly created Deposit group.
4. In this section, I have added the Charges code for deposits. In this case, all vendors charge a $100 deposit on each container. Also, the deposit fee is tax exempt for all of our jurisdictions. We use tax groups to manage this so I have assigned this as well.
There are so many things that may be done with automatic charges! It is really just a matter of identifying how to make this useful for your business. Once the scenarios have been identified, it becomes easier to identify how to establish groups and automatic charges.
– Above in 2), we could have selected a specific vendor to enable a vendor specific deposit fee. Alternately, a vendor charges group could have been established and assigned to further group specific vendors to specific charges.
– Above in 3), we could have selected a specific item to apply the charge to. In that case, an item charges group would not have been utilized.
– Above in 4), additional lines could have been added as appropriate. Imagine that the 55 gallon poly drum is delivered on a pallet and there is a charge of $25 for this. I could add “Pallet” at fixed charge value of $25.
Charge Codes for Purchase Orders
Let’s take a look at how this works on the purchase order. I created a purchase order for 360 lbs of M0062 Resin which is the equivalent of a single poly drum. To view or edit the charges at a line level, select Financial, and then select Maintain charges from the appropriate line.
The detail is shown in the following screen. The charge value is editable if an adjustment is required.
The total value of charges is also visible from the View Totals button in the Purchase order tab of the ribbon.
Note: Standard function of the calculation of cash discounts does include the value of charges.
Charges appear as a summary total on the purchase order as shown.
When we receive the invoice from the vendor, they have included a credit for $200 (deposit refunded) which represents two drums that have been returned to the supplier. Earlier, I directed the ability to edit line charges to the Financials button at the line level. Our business process is to manage refunds credited at the header level, so I will select Maintain charges from the Financials tab in the ribbon. A new charge transaction is created with an entry to reflect the credit of ($200) as shown. When posted, the voucher will show an entry for $100 debit (deposit charged at line for current product purchase) and an entry for ($200) credit (refund of deposit collected on prior purchases).
If it is desirable, a separate charge code could be created for the refund on the deposits.
For more on addressing the use of customer orders and invoicing, see my post: Exploring Charge Codes in AX 2012: Part II.
1 Comment
Leave your reply.