A few years ago, my mother had a heart attack that required several long, frightening days in the hospital. When the initial crisis passed, she returned home under strict doctor’s orders about the types of food she should have in her diet (and the types she shouldn’t).
As a family, we figured we could easily find and provide what she needed. After all, most of us were trained medical professionals.
Boy, were we wrong.
We found our time and energy stretched thin as we tried to manage her new medications, fatigue and the emotional strain of this sudden health crisis on the entire family. As a result, we had to make difficult judgment calls between food that was quick and easy to prepare, and food that was nutritious but required more time and effort.
READ: Colorado Sun opinion columnists.
This scenario happens across Colorado every day. Some of the facts may be different; perhaps it is someone with kidney disease or cancer, but the challenges are similar. All too often, when very ill people are told what to eat by their doctor, they are left to figure out what that means all by themselves. And this is, of course, at a time in their lives when they usually have the least mental and physical energy, and financial means, to put towards grocery shopping, meal planning and food preparation.
For people living with chronic and severe illnesses, proper nutrition can be the difference between life and death. That is not to downplay the critical importance of prescription medication, but medicine can do only so much when people have to rely on unhealthy food to satisfy their hunger.
That’s why the rallying cry of my nonprofit organization, Project Angel Heart, is “food is medicine.” Regardless of a person’s background or circumstances, we believe everyone should have access to the nutrition they need – especially when they are sick.
In our kitchen in North Denver, we create meals from scratch, tailored to our clients’ illnesses. Each week, hundreds of volunteers help us package and deliver these meals to our clients’ homes while our team of nutritionists provides education, counseling and other support to improve clients’ health and wellbeing. Most importantly, our entire program is provided at no cost to our clients.
We go to these lengths because we know this approach works. Through our own research, we know that the medically tailored meals we provide reduce health-care costs and re-hospitalization.
Many reputable studies and a wide breadth of medical research have also demonstrated that providing proper nutrition to people who are seriously ill keeps them out of the hospital, reduces their out-of-pocket medical expenses, and promotes overall well-being.
The biggest challenge we face is funding this vital program. We rely heavily on the generosity of Coloradans to donate their time and resources to our work. In our state, there are very limited circumstances in which a person can access medically tailored nutrition through their health-care provider or insurance plan. That’s not true in other parts of the country.
Recognizing the important role nutrition plays in reducing health-care costs, many states include home-delivered meals as a benefit for chronically ill individuals in their state-run insurance plans – a move supported by the Center for Medicaid and Medicare Services.
TODAY’S UNDERWRITER
Gov. Jared Polis has ambitiously made reducing health-care costs a top priority for his administration. In my opinion, providing chronically ill people the nutrition they need to manage their illness at home is a key step to realizing this goal.
When a proven, cost-effective intervention like this exists, we must remove all barriers to access for individuals and families in need. Colorado should follow other states and make medically tailored meals a more accessible part of healthcare.
Including meals in private insurance plans and state-regulated and state-funded insurance programs could go a long way towards alleviating food insecurity and providing access to food as medicine for tens of thousands of Coloradans.
Owen Ryan, of Denver, is president and CEO of Project Angel Heart.<<