For a long time, perhaps millions of years, the common soil bacterium Agrobacterium tumefaciens has been doing what molecular biologists are now striving to do. It has been inserting foreign genes into plants and getting the plants to express those genes in the form of proteins.
--Mary-Dell
Chilton
The bacterium Agrobacterium tumefaciens (AT) causes plants to form a tumor, called a gall, located most commonly at the crown of the plant--the junction of root and stem. This "crown gall disease" affects broad-leafed plants such as fruit trees, grapes, and ornamental plants.
The disease has been known since the turn of the century, when scientists determined that AT isolated from a crown gall and inoculated into a wound in a healthy plant would cause the latter to develop a tumor as well.
Scientists suspected by the early 1970s that the causative agent must be nucleic acid in some mobile form that can be transferred from the bacterium to the plant and incorporated into the plant cells, probably carried by a virus or a plasmid. A plasmid is a small piece of "auxiliary" double-stranded DNA, separate from the regular host chromosomes, carrying special genes that may confer survival advantages or other characteristics—traits such as antibiotic resistance, pathogenicity, or ability to metabolize rare compounds.
In the late 1970s, UW microbiologists Mary-Dell Chilton, Eugene W. Nester, and Milton P. Gordon were the first to prove that it was DNA from a plasmid in Agrobacteriumthat was transferred and integrated into the plant DNA to cause crown gall tumors. Furthermore, they identified which particular plasmid DNA segments were involved. In fact, the UW team deduced the first genetic map of one of the tumor-inducing plasmids.
"This natural case of genetic engineering of plants is of major importance to biology because it demonstrates that DNA can be transferred between biological kingdoms," emphasizes Nester. Moreover, he notes, Agrobacterium has become the major vector for genetic engineering of plants.
Chilton explains that the unique biological characteristics of this plasmid make it a natural agent for gene transfer. It causes pieces of plasmid DNA to be inserted into the plant DNA. The host plant then maintains that foreign genetic material, replicating it along with the host plant's own genes, which are transcribed to ultimately produce proteins. The general strategy would therefore be to design a "recombinant" plasmid containing a foreign gene that codes for a desired trait that is to be transferred to the plant. The trait might be resistance to herbicides, for example, or the ability to synthesize a specific protein of commercial interest, like an antibiotic. Next, the recombinant plasmid is transferred into Agrobacterium. Finally, bacteria containing these modified plasmids are inoculated into the host plant and go about their business of inserting plasmid DNA fragments into the host plant cells. The first genetically engineered food now available in supermarkets, the "Flavor-Savr" tomato, owes its existence to gene transfer by Agrobacterium.