In the San Diego region, the average price for regular gas has set a record every day since March 3.
Lately, gas prices also have been setting daily records statewide and across the United States.
Nationwide, the average price for a gallon of regular gasoline hit a new high of $3.28 yesterday, according to AAA's Daily Fuel Gauge Report. California's statewide average was a record $3.619.
To Alan Gin, it's like déjà vu all over again. The University of San Diego economist recalls that gasoline prices made a similar run last spring.
Prices began escalating roughly a year ago and rose to a peak May 7, when the statewide average for unleaded regular was $3.46. The same thing happened in 2006, when the statewide average peaked May 8 at $3.33.
“I'm interested in seeing if this pattern will continue,” Gin said. “My sense is we're probably going to reach some sort of peak in the next couple of months.”
So if a gallon of regular already is a painful $3.61, does that mean it's going to hit an excruciating $4 in coming weeks?
“My guess is that we're not going to see $4-a-gallon prices nationwide, but in California, it's probably going to get pretty close,” said Severin Borenstein of the University of California Energy Institute in Berkeley.
UCAN gasoline specialist Charles Langley said he fervently hopes that prices won't hit $4 a gallon, though some prominent oil-watchers are predicting it.
“It seems that first week in May tends to be kind of a killer, when it peaks or when it comes close to peaking,” Langley said. “This year, it may be happening earlier.”
Langley contends the soaring price of gasoline is defying gravity because, “When we look at market fundamentals, it's very hard to justify.”
Langley and other experts say the force levitating gasoline prices has been emanating from the New York Mercantile Exchange, where traders have pushed the price of crude oil to unmatched heights.
Yesterday, crude-oil trading settled slightly at $110.21 a barrel, after hitting a record of $111 on Thursday.
To Kloza and other energy analysts, such trading means crude prices have decoupled from the conventional market forces of supply and demand.
On the supply side, gasoline stocks in the United States are at a 15-year high. On Thursday, a U.S. government report showed that stocks of domestic crude oil also rose more than expected, and are at their highest level since November.
“We haven't seen any unusual supply issues in the marketplace,” said Tupper Hull, a spokesman for the Sacramento-based Western States Petroleum Association. Hull also said there have been no refinery shutdowns so far this year, unlike the previous two springs, when the industry said refinery outages contributed to higher prices.
Demand also appears to be softening. The California State Board of Equalization said Feb. 28 that statewide gasoline consumption declined by 3.7 percent in November.
But energy experts say the key difference this year is what's happening in the oil commodities markets, where traders have bid up crude prices to unprecedented heights.
“It's not really about (gasoline) supply and demand,” said Phil Flynn, a vice president and energy analyst with Alaron Trading Corp. of Chicago. “It's about the increasing price of crude, which is really being driven by the declining value of the dollar.”
The weak dollar showed an immediate effect in oil contracts, which are negotiated in dollars, because major oil exporters such as Saudi Arabia and Kuwait are raising their prices to ensure that they get the same value for each barrel sold.
Yesterday, the dollar fell to an all-time low against the euro, which means a barrel of crude oil that costs $110 is a comparative bargain at roughly 70.48 euros.
A more dramatic consequence of the weak dollar, though, has been playing out on Wall Street.
Investors who usually would buy foreign bonds as a hedge against the declining value of the dollar now see investments in crude-oil futures as a better bet.
“Speculators realize that if they hang on to dollars, they're going to lose money,” Flynn said. “So what we're seeing is that oil and gas are being used as a financial hedge against the dollar.”
It is a risky, but logical bet to economists such as Lester Lave of Carnegie Mellon University. By investing in contracts for future crude deliveries, Lave said investors see an opportunity to gain a benefit from the appreciation in the price of oil as well as a hedge against the declining value of the dollar.
“Blame OPEC and the speculators,” said A.F. Alhajji, an energy economist and associate professor at Ohio Northern University.
As higher oil prices generated greater revenue, Saudi Arabia and other members of the Organization of Petroleum Exporting Countries poured the extra cash into investment funds, Alhajji said. Those investment funds, in turn, used the additional cash to speculate in the oil market.
“That means, to some extent, that OPEC and the speculators are – one!” Alhajji said.
Lave concurred. “Right now, people are just making a lot of money at this, and they're just going to keep driving prices up,” he said.
Flynn said: “We're seeing a big bubble in the price of oil and gas, and it's definitely going to pop. I just can't say if it's going to pop two months from now or two years from now.”
He added that either way, “what is happening now is beyond normal. It's extraordinary.”
Bruce Bigelow: (619) 293-1314; bruce.bigelow@uniontrib.com