A quick-thinking driver has managed to avoid paying tolls on the controversial Mersey Gateway Bridge.
Damian Curzon outwitted bridge bosses with his extensive legal knowledge, resulting in a landmark ruling that could have huge implications for all bridge fines.
The Scrap Mersey Tolls (SMT) campaigner exposed a catalogue of errors in the wording of two penalty charge notices (PCNs) he received for failing to pay the £2 crossing charge on June 15 2018.
One of those errors was use of the word “toll” in the PCN – when the legal term is actually road user charge.
In a decision published by the Traffic Penalty Tribunal (TPT), adjudicator M.F. Kennedy said referring to non-payment of a 'required toll' breached 2013 Regulations under the Transport Act 2000, and made the PCN issued 'defective'.
Mr Kennedy explained that the 2013 Regulations allowed for local authorities to impose a ‘road user charge’ under a charging scheme, and that a penalty charge could be imposed if the ‘road user charge’ was not paid within the time and manner it was required.
However, he said Halton Borough Council (HBC) did not comply with these regulations because: The PCNs issued to Mr Curzon referred to non-payment of a ‘required toll’, so did not ‘accurately reflect the contravention that has occurred’ (i.e. non-payment of the road user charge).
The PCNs should have stated that the penalty arose as a result of not paying a road user charge.
A PCN must state the grounds on which the charging authority believes the penalty charge is payable. In this case, it is a road user charge under a charging scheme that has not been paid.
Use of the word ‘toll’ is not an accurate description of the sum payable for use of the Mersey Gateway Bridge or Silver Jubilee Bridge.
The appeals made by Mr Curzon against the two PCNs were upheld because of this and various other errors known as ‘procedural improprieties’ that rendered the fines unenforceable.
Delivering a further blow to bridge bosses, Mr Kennedy also observed signs on the bridge indicated the need to pay a toll, not the road user charge.
He said this meant the signage of the scheme is not authorised to “convey the liability” that a fee is in place.
In a statement, Halton Council said it’s still “business as usual” on the bridge, adding that it will contest the TPT’s decision.
However, the decision has once again put the question of the legality of the charges in doubt, with Scrap Mersey Toll campaigners saying an “overhaul of the system” is now required.
One issue that came to light in Mr Curzon’s landmark case relates to how Halton Council administer the bridge through third party contractors.
The tolls are collected and enforced by Spanish company Emovis under the brand name ‘Merseyflow’, who issue PCNs and consider appeals on behalf of Halton Borough Council (HBC).
This was arranged under a £1.86bn private finance deal in 2014, which saw the establishment of a Mersey Gateway Crossing’s Board – an Arms Length company set up by HBC with delegated authority to deliver the entire Mersey Gateway Project.
But adjudicator M.F Kennedy suggested the council can’t rely on delegated bodies to make decisions when drivers contest PCNs.
The representations made by Mr Curzon were not considered directly by any member of HBC or HBC staff, but were considered by Merseyflow, a third party contractor.
A local authority may, broadly, delegate administrative function, but it may not delegate its judicial functions. The consideration of representations is a discretionary decision, which is a judicial function.
HBC were not entitled to delegate their power of discretion to Emovis or any other non-authority third party.
It follows that HBC did not consider the representations made by Mr Curzon (and therefore did not respond to them within 56 days [or at all]), so HBC are deemed to have accepted the representations.
It is unclear what this will mean moving forward.
The TPT say they consider each representation on a case by case basis and that the Road Charging Order 2018 is still legally valid.
This has been reiterated by Halton Council, who say decisions made by the transport watchdog “do not carry weight as precedent.”
The authority pointed to an eariler ruling which judged signs on the bridge to be adequate, and said any ruling by the TPT does NOT in law, invalidate or remove their powers to enforce tolls.
Issuing a robust statement they added: “Any suggestion that the council has no power to charge or enforce how it does this or that the council’s is acting inappropriately or “illegally” is misleading, inaccurate and wrong in law.”
Despite this, Scrap Mersey Toll campaigners are refusing to give up hope and have called on local politicians to back their cause.
In a statement the group said:”The Tribunal have judged that Halton Council did not comply with some of the regulations. It is our view that it is far deeper than that and the law has been turned upside down by the council.
“We believe that the tolls can not now be enforced unless Parliament changes the current law.
“We fear that the Council will ignore this decision of the tribunal but hope that instead the politicians at local and national level will now realise that the best course is to scrap the tolls.
“Tolling a previously free crossing is fundamentally unfair and that injustice is compounded by a grossly excessive penalty system that causes considerable distress.”
Last Updated:
Are you sure you want to delete this comment?
Report This Comment